/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.util.delaunay.AutoClust;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.graph.util.delaunay.DelaunayTest;
import org.geotools.graph.util.delaunay.DelaunayTriangulator;
import org.geotools.graph.util.delaunay.GraphViewer;

public class AutoClustMain {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.graph");

    public static void main(String[] args) {
        boolean useRandom = true;
        DelaunayNode[] nodes = useRandom ? DelaunayTest.createRandomNodes(250, 180, 180, 100) : DelaunayTest.createStateNodes();
        Graph triangulation = DelaunayTriangulator.triangulate(nodes);
        LOGGER.fine("Triangulation is: " + triangulation);
        Graph clusters = AutoClust.runAutoClust(triangulation);
        LOGGER.fine("Clusters supposedly are " + clusters);
        JFrame frame = new JFrame();
        GraphViewer viewer = new GraphViewer();
        viewer.setGraph(clusters);
        frame.getContentPane().add(viewer);
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(800, 800));
        frame.setTitle("Final");
        frame.setVisible(true);
    }
}

