/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;

public class AutoClustUtils {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.graph");

    public static Vector findConnectedComponents(Collection nodes, Collection edges) {
        Vector<BasicGraph> components = new Vector<BasicGraph>();
        Vector nodesVisited = new Vector();
        Iterator nodesIt = nodes.iterator();
        while (nodesIt.hasNext()) {
            Node next = (Node)nodesIt.next();
            if (nodesVisited.contains(next)) continue;
            Vector componentNodes = new Vector();
            Vector componentEdges = new Vector();
            AutoClustUtils.expandComponent(next, edges, componentNodes, componentEdges);
            nodesVisited.addAll(componentNodes);
            BasicGraph component = new BasicGraph(componentNodes, componentEdges);
            components.add(component);
        }
        return components;
    }

    private static void expandComponent(Node node, Collection edges, Collection componentNodes, Collection componentEdges) {
        if (componentNodes.contains(node)) {
            LOGGER.fine("I've already expanded from " + node);
        } else {
            componentNodes.add(node);
            LOGGER.finer("Adding " + node + " to component");
            Vector adjacentEdges = AutoClustUtils.findAdjacentEdges(node, edges);
            componentEdges.addAll(adjacentEdges);
            LOGGER.finer("Adding " + adjacentEdges + " to component");
            Iterator aeIt = adjacentEdges.iterator();
            while (aeIt.hasNext()) {
                Edge next = (Edge)aeIt.next();
                LOGGER.finer("looking at edge " + next);
                Node additionalNode = next.getOtherNode(node);
                LOGGER.finer("its other node is " + additionalNode);
                if (additionalNode == null) {
                    throw new RuntimeException("I tried to get the other node of this edge " + next + " but it doesn't have " + node);
                }
                AutoClustUtils.expandComponent(additionalNode, edges, componentNodes, componentEdges);
            }
        }
    }

    public static Vector findAdjacentEdges(Node node, Collection edges) {
        Vector<Edge> ret = new Vector<Edge>();
        Iterator it = edges.iterator();
        while (it.hasNext()) {
            Edge next = (Edge)it.next();
            if (!next.getNodeA().equals(node) && !next.getNodeB().equals(node)) continue;
            ret.add(next);
        }
        return ret;
    }
}

