/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import java.util.logging.Logger;
import org.geotools.graph.structure.basic.BasicEdge;
import org.geotools.graph.structure.line.XYNode;
import org.geotools.graph.util.delaunay.Triangle;

public class DelaunayEdge
extends BasicEdge {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.graph");
    Triangle faceA;
    Triangle faceB;

    public DelaunayEdge(XYNode nodeA, XYNode nodeB) {
        super(nodeA, nodeB);
    }

    public void disconnect() {
        this.getNodeA().remove(this);
        this.getNodeB().remove(this);
    }

    public void setFaceA(Triangle t) {
        if (t.equals(this.faceB)) {
            throw new RuntimeException("Face A must be different from Face B.");
        }
        this.faceA = t;
    }

    public void setFaceB(Triangle t) {
        if (t.equals(this.faceA)) {
            throw new RuntimeException("Face A must be different from Face B.");
        }
        this.faceB = t;
    }

    public boolean hasEndPoint(XYNode node) {
        return node.equals(this.getNodeA()) || node.equals(this.getNodeB());
    }

    public Triangle getOtherFace(Triangle t) {
        if (this.faceA.equals(t)) {
            return this.faceB;
        }
        if (this.faceB.equals(t)) {
            return this.faceA;
        }
        LOGGER.warning("Oops.  Input face is " + t);
        LOGGER.warning("Face A is " + this.faceA);
        LOGGER.warning("Face B is " + this.faceB);
        throw new RuntimeException("DelaunayEdge.getOtherFace must receive as input one of the faces bordering that edge.");
    }

    public void setOtherFace(Triangle newT, Triangle oldT) {
        if (this.faceA.equals(oldT)) {
            if (newT.equals(this.faceA)) {
                LOGGER.warning("Oops.  Face A is " + this.faceA + " and new Triangle is " + newT);
                throw new RuntimeException("Face A must be different from Face B.");
            }
            this.setFaceB(newT);
        } else if (this.faceB.equals(oldT)) {
            if (newT.equals(this.faceB)) {
                LOGGER.warning("Oops.  Face B is " + this.faceB + " and new Triangle is " + newT);
                throw new RuntimeException("Face A must be different from Face B.");
            }
            this.setFaceA(newT);
        } else {
            throw new RuntimeException("DelaunayEdge.setOtherFace must have either faceA or faceB as the oldT parameter.");
        }
    }

    public double getEuclideanDistance() {
        return ((XYNode)this.getNodeA()).getCoordinate().distance(((XYNode)this.getNodeB()).getCoordinate());
    }

    public boolean equals(Object o) {
        return o instanceof DelaunayEdge && (this.getNodeA().equals(((DelaunayEdge)o).getNodeA()) && this.getNodeB().equals(((DelaunayEdge)o).getNodeB()) || this.getNodeA().equals(((DelaunayEdge)o).getNodeB()) && this.getNodeB().equals(((DelaunayEdge)o).getNodeA()));
    }

    public String toString() {
        return this.getNodeA().toString() + "--" + this.getNodeB().toString();
    }
}

