/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Dimension;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.graph.util.delaunay.DelaunayTriangulator;
import org.geotools.graph.util.delaunay.GraphViewer;

public class DelaunayTest {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.graph");

    public static void main(String[] args) {
        boolean useRandom = false;
        Graph g = useRandom ? DelaunayTriangulator.triangulate(DelaunayTest.createRandomNodes(250, 250, 250, 0)) : DelaunayTriangulator.triangulate(DelaunayTest.createStateNodes());
        LOGGER.fine("Graph supposedly is " + g);
        JFrame frame = new JFrame();
        GraphViewer viewer = new GraphViewer();
        viewer.setGraph(g);
        frame.getContentPane().add(viewer);
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(400, 400));
        frame.setVisible(true);
    }

    public static DelaunayNode[] createStateNodes() {
        DelaunayNode[] nodeArray = new DelaunayNode[49];
        for (int i = 0; i < 49; ++i) {
            nodeArray[i] = new DelaunayNode();
        }
        nodeArray[0].setCoordinate(new Coordinate(-89.0, 40.0));
        nodeArray[1].setCoordinate(new Coordinate(-92.0, 38.0));
        nodeArray[2].setCoordinate(new Coordinate(-112.0, 34.0));
        nodeArray[3].setCoordinate(new Coordinate(-98.0, 36.0));
        nodeArray[4].setCoordinate(new Coordinate(-79.0, 36.0));
        nodeArray[5].setCoordinate(new Coordinate(-86.0, 36.0));
        nodeArray[6].setCoordinate(new Coordinate(-99.0, 31.0));
        nodeArray[7].setCoordinate(new Coordinate(-106.0, 34.0));
        nodeArray[8].setCoordinate(new Coordinate(-87.0, 33.0));
        nodeArray[9].setCoordinate(new Coordinate(-90.0, 33.0));
        nodeArray[10].setCoordinate(new Coordinate(-83.0, 33.0));
        nodeArray[11].setCoordinate(new Coordinate(-77.0, 39.0));
        nodeArray[12].setCoordinate(new Coordinate(-81.0, 34.0));
        nodeArray[13].setCoordinate(new Coordinate(-92.0, 35.0));
        nodeArray[14].setCoordinate(new Coordinate(-92.0, 31.0));
        nodeArray[15].setCoordinate(new Coordinate(-82.0, 29.0));
        nodeArray[16].setCoordinate(new Coordinate(-85.0, 44.0));
        nodeArray[17].setCoordinate(new Coordinate(-110.0, 47.0));
        nodeArray[18].setCoordinate(new Coordinate(-69.0, 45.0));
        nodeArray[19].setCoordinate(new Coordinate(-100.0, 47.0));
        nodeArray[20].setCoordinate(new Coordinate(-100.0, 44.0));
        nodeArray[21].setCoordinate(new Coordinate(-108.0, 43.0));
        nodeArray[22].setCoordinate(new Coordinate(-76.0, 39.0));
        nodeArray[23].setCoordinate(new Coordinate(-90.0, 45.0));
        nodeArray[24].setCoordinate(new Coordinate(-115.0, 44.0));
        nodeArray[25].setCoordinate(new Coordinate(-73.0, 44.0));
        nodeArray[26].setCoordinate(new Coordinate(-94.0, 46.0));
        nodeArray[27].setCoordinate(new Coordinate(-121.0, 44.0));
        nodeArray[28].setCoordinate(new Coordinate(-72.0, 44.0));
        nodeArray[29].setCoordinate(new Coordinate(-94.0, 42.0));
        nodeArray[30].setCoordinate(new Coordinate(-72.0, 42.0));
        nodeArray[31].setCoordinate(new Coordinate(-100.0, 42.0));
        nodeArray[32].setCoordinate(new Coordinate(-76.0, 43.0));
        nodeArray[33].setCoordinate(new Coordinate(-81.0, 39.0));
        nodeArray[34].setCoordinate(new Coordinate(-78.0, 41.0));
        nodeArray[35].setCoordinate(new Coordinate(-73.0, 42.0));
        nodeArray[36].setCoordinate(new Coordinate(-72.0, 42.0));
        nodeArray[37].setCoordinate(new Coordinate(-75.0, 40.0));
        nodeArray[38].setCoordinate(new Coordinate(-86.0, 40.0));
        nodeArray[39].setCoordinate(new Coordinate(-117.0, 39.0));
        nodeArray[40].setCoordinate(new Coordinate(-112.0, 39.0));
        nodeArray[41].setCoordinate(new Coordinate(-120.0, 37.0));
        nodeArray[42].setCoordinate(new Coordinate(-83.0, 40.0));
        nodeArray[43].setCoordinate(new Coordinate(-120.0, 47.0));
        nodeArray[44].setCoordinate(new Coordinate(-77.5, 39.5));
        nodeArray[45].setCoordinate(new Coordinate(-106.0, 39.0));
        nodeArray[46].setCoordinate(new Coordinate(-85.0, 38.0));
        nodeArray[47].setCoordinate(new Coordinate(-98.0, 38.0));
        nodeArray[48].setCoordinate(new Coordinate(-79.0, 38.0));
        return nodeArray;
    }

    public static DelaunayNode[] createRandomNodes(int num, int xMax, int yMax, int clusterSize) {
        Random r = new Random();
        DelaunayNode[] nodeArray = new DelaunayNode[num];
        for (int i = 0; i < num; ++i) {
            DelaunayNode next = new DelaunayNode();
            do {
                int y;
                int x;
                if (i < clusterSize) {
                    x = r.nextInt(xMax / 8) + xMax / 3;
                    y = r.nextInt(yMax / 8) + 2 * yMax / 3;
                } else {
                    x = r.nextInt(xMax);
                    y = r.nextInt(yMax);
                }
                next.setCoordinate(new Coordinate((double)x, (double)y));
            } while (DelaunayTest.arrayContains(next, nodeArray, i));
            nodeArray[i] = next;
        }
        return nodeArray;
    }

    private static boolean arrayContains(DelaunayNode node, DelaunayNode[] nodes, int index) {
        boolean ret = false;
        boolean done = false;
        int i = 0;
        while (!done) {
            if (i < index) {
                done = ret = nodes[i].equals(node);
                ++i;
                continue;
            }
            done = true;
        }
        return ret;
    }
}

