/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraph;
import org.geotools.graph.util.delaunay.DelaunayEdge;
import org.geotools.graph.util.delaunay.DelaunayNode;
import org.geotools.graph.util.delaunay.Triangle;
import org.geotools.math.Line;

public class DelaunayTriangulator {
    public static DelaunayNode temp1;
    public static DelaunayNode temp2;
    public static DelaunayNode temp3;
    private static final Logger LOGGER;

    public static Graph triangulate(FeatureCollection fc) {
        FeatureIterator iter = fc.features();
        int size = fc.size();
        DelaunayNode[] nodes = new DelaunayNode[size];
        int index = 0;
        boolean duplicates = false;
        while (iter.hasNext()) {
            Feature next = iter.next();
            Geometry geom = next.getDefaultGeometry();
            Point centroid = geom instanceof Point ? (Point)geom : geom.getCentroid();
            DelaunayNode node = new DelaunayNode();
            node.setCoordinate(centroid.getCoordinate());
            node.setFeature(next);
            if (DelaunayTriangulator.arrayContains(node, nodes, index)) continue;
            nodes[index] = node;
            ++index;
        }
        DelaunayNode[] trimmed = new DelaunayNode[index];
        for (int i = 0; i < index; ++i) {
            trimmed[i] = nodes[i];
        }
        return DelaunayTriangulator.triangulate(trimmed);
    }

    private static boolean arrayContains(DelaunayNode node, DelaunayNode[] nodes, int index) {
        boolean ret = false;
        boolean done = false;
        int i = 0;
        while (!done) {
            if (i < index) {
                done = ret = nodes[i].equals(node);
                ++i;
                continue;
            }
            done = true;
        }
        return ret;
    }

    public static Graph triangulate(DelaunayNode[] nodes) {
        DelaunayNode[] tempNodes = new DelaunayNode[nodes.length + 3];
        double max = 0.0;
        for (int i = 0; i < nodes.length; ++i) {
            tempNodes[i] = nodes[i];
            max = Math.max(max, Math.abs(nodes[i].getCoordinate().x));
            max = Math.max(max, Math.abs(nodes[i].getCoordinate().y));
        }
        tempNodes[nodes.length] = new DelaunayNode();
        tempNodes[nodes.length].setCoordinate(new Coordinate(0.0, 3.0 * max));
        tempNodes[nodes.length + 1] = new DelaunayNode();
        tempNodes[nodes.length + 1].setCoordinate(new Coordinate(3.0 * max, 0.0));
        tempNodes[nodes.length + 2] = new DelaunayNode();
        tempNodes[nodes.length + 2].setCoordinate(new Coordinate(-3.0 * max, -3.0 * max));
        temp1 = tempNodes[nodes.length];
        temp2 = tempNodes[nodes.length + 1];
        temp3 = tempNodes[nodes.length + 2];
        Vector<Triangle> triangleList = new Vector<Triangle>();
        DelaunayEdge e1 = new DelaunayEdge(tempNodes[nodes.length], tempNodes[nodes.length + 1]);
        DelaunayEdge e2 = new DelaunayEdge(tempNodes[nodes.length], tempNodes[nodes.length + 2]);
        DelaunayEdge e3 = new DelaunayEdge(tempNodes[nodes.length + 1], tempNodes[nodes.length + 2]);
        Triangle first = new Triangle(e1, e2, e3);
        e1.setFaceA(first);
        e2.setFaceA(first);
        e3.setFaceA(first);
        DelaunayNode U1 = new DelaunayNode();
        U1.setCoordinate(new Coordinate(Double.POSITIVE_INFINITY, 0.0));
        DelaunayNode U2 = new DelaunayNode();
        U2.setCoordinate(new Coordinate(0.0, Double.POSITIVE_INFINITY));
        DelaunayNode U3 = new DelaunayNode();
        U3.setCoordinate(new Coordinate(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        Triangle UNBOUNDED = new Triangle(new DelaunayEdge(U1, U2), new DelaunayEdge(U1, U3), new DelaunayEdge(U2, U3));
        e1.setFaceB(UNBOUNDED);
        e2.setFaceB(UNBOUNDED);
        e3.setFaceB(UNBOUNDED);
        triangleList.add(first);
        for (int i = 0; i < nodes.length; ++i) {
            DelaunayTriangulator.insertNode(tempNodes[i], triangleList);
        }
        Vector<Edge> edgeList = new Vector<Edge>();
        Iterator triangleIterator = triangleList.iterator();
        while (triangleIterator.hasNext()) {
            Triangle next = (Triangle)triangleIterator.next();
            Edge[] edges = next.getEdges();
            for (int i = 0; i < 3; ++i) {
                if (((DelaunayEdge)edges[i]).hasEndPoint(tempNodes[nodes.length]) || ((DelaunayEdge)edges[i]).hasEndPoint(tempNodes[nodes.length + 1]) || ((DelaunayEdge)edges[i]).hasEndPoint(tempNodes[nodes.length + 2]) || edgeList.contains(edges[i])) continue;
                edgeList.add(edges[i]);
            }
        }
        Vector<DelaunayNode> nodeList = new Vector<DelaunayNode>();
        for (int i = 0; i < nodes.length; ++i) {
            nodeList.add(nodes[i]);
        }
        BasicGraph g = new BasicGraph(nodeList, edgeList);
        return g;
    }

    private static void insertNode(DelaunayNode newNode, Vector triangleList) {
        Iterator triangleIterator = triangleList.iterator();
        Triangle contains = null;
        Triangle borderA = null;
        Triangle borderB = null;
        boolean notDone = true;
        block5: while (triangleIterator.hasNext() && notDone) {
            Triangle next = (Triangle)triangleIterator.next();
            int relation = next.relate(newNode);
            switch (relation) {
                case 1: {
                    contains = next;
                    notDone = false;
                    continue block5;
                }
                case 2: {
                    if (borderA == null) {
                        borderA = next;
                        notDone = true;
                        continue block5;
                    }
                    borderB = next;
                    notDone = false;
                    continue block5;
                }
                case 0: {
                    notDone = true;
                    continue block5;
                }
            }
            throw new RuntimeException("So the point isn't inside, outside, or on the edge of this triangle?!");
        }
        if (contains != null) {
            Node[] triangleNodes = contains.getNodes();
            Edge[] triangleEdges = contains.getEdges();
            DelaunayEdge newEdgeP_0 = new DelaunayEdge(newNode, (DelaunayNode)triangleNodes[0]);
            DelaunayEdge newEdgeP_1 = new DelaunayEdge(newNode, (DelaunayNode)triangleNodes[1]);
            DelaunayEdge newEdgeP_2 = new DelaunayEdge(newNode, (DelaunayNode)triangleNodes[2]);
            DelaunayEdge oldEdge0_1 = null;
            DelaunayEdge oldEdge0_2 = null;
            DelaunayEdge oldEdge1_2 = null;
            for (int i = 0; i < 3; ++i) {
                if (((DelaunayEdge)triangleEdges[i]).hasEndPoint((DelaunayNode)triangleNodes[0])) {
                    if (((DelaunayEdge)triangleEdges[i]).hasEndPoint((DelaunayNode)triangleNodes[1])) {
                        oldEdge0_1 = (DelaunayEdge)triangleEdges[i];
                        continue;
                    }
                    oldEdge0_2 = (DelaunayEdge)triangleEdges[i];
                    continue;
                }
                oldEdge1_2 = (DelaunayEdge)triangleEdges[i];
            }
            Triangle newTriangleP_0_1 = new Triangle(newEdgeP_0, newEdgeP_1, oldEdge0_1);
            Triangle newTriangleP_0_2 = new Triangle(newEdgeP_0, newEdgeP_2, oldEdge0_2);
            Triangle newTriangleP_1_2 = new Triangle(newEdgeP_1, newEdgeP_2, oldEdge1_2);
            Triangle farSide0_1 = oldEdge0_1.getOtherFace(contains);
            Triangle farSide0_2 = oldEdge0_2.getOtherFace(contains);
            Triangle farSide1_2 = oldEdge1_2.getOtherFace(contains);
            oldEdge0_1.setOtherFace(newTriangleP_0_1, farSide0_1);
            oldEdge0_2.setOtherFace(newTriangleP_0_2, farSide0_2);
            oldEdge1_2.setOtherFace(newTriangleP_1_2, farSide1_2);
            newEdgeP_0.setFaceA(newTriangleP_0_1);
            newEdgeP_0.setFaceB(newTriangleP_0_2);
            newEdgeP_1.setFaceA(newTriangleP_0_1);
            newEdgeP_1.setFaceB(newTriangleP_1_2);
            newEdgeP_2.setFaceA(newTriangleP_0_2);
            newEdgeP_2.setFaceB(newTriangleP_1_2);
            triangleList.remove(contains);
            triangleList.add(newTriangleP_0_1);
            triangleList.add(newTriangleP_0_2);
            triangleList.add(newTriangleP_1_2);
            LOGGER.finer("was inside " + contains);
            LOGGER.finer("triangle List now is " + triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_0_1, oldEdge0_1, newNode, triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_0_2, oldEdge0_2, newNode, triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_1_2, oldEdge1_2, newNode, triangleList);
        } else if (borderA != null && borderB != null) {
            DelaunayEdge shared = (DelaunayEdge)borderA.getSharedEdge(borderB);
            if (shared == null) {
                throw new RuntimeException("The two bordering triangles for a border case apparently don't share an edge(!)");
            }
            DelaunayNode shared1 = (DelaunayNode)shared.getNodeA();
            DelaunayNode shared2 = (DelaunayNode)shared.getNodeB();
            DelaunayNode onlyInA = (DelaunayNode)borderA.getThirdNode(shared);
            DelaunayNode onlyInB = (DelaunayNode)borderB.getThirdNode(shared);
            DelaunayEdge newEdgeP_1 = new DelaunayEdge(newNode, shared1);
            DelaunayEdge newEdgeP_2 = new DelaunayEdge(newNode, shared2);
            DelaunayEdge newEdgeP_A = new DelaunayEdge(newNode, onlyInA);
            DelaunayEdge newEdgeP_B = new DelaunayEdge(newNode, onlyInB);
            DelaunayEdge oldEdgeA_1 = (DelaunayEdge)borderA.getOppositeEdge(shared2);
            DelaunayEdge oldEdgeA_2 = (DelaunayEdge)borderA.getOppositeEdge(shared1);
            DelaunayEdge oldEdgeB_1 = (DelaunayEdge)borderB.getOppositeEdge(shared2);
            DelaunayEdge oldEdgeB_2 = (DelaunayEdge)borderB.getOppositeEdge(shared1);
            Triangle farSideA_1 = oldEdgeA_1.getOtherFace(borderA);
            Triangle farSideA_2 = oldEdgeA_2.getOtherFace(borderA);
            Triangle farSideB_1 = oldEdgeB_1.getOtherFace(borderB);
            Triangle farSideB_2 = oldEdgeB_2.getOtherFace(borderB);
            Triangle newTriangleP_A_1 = new Triangle(newEdgeP_A, newEdgeP_1, oldEdgeA_1);
            Triangle newTriangleP_A_2 = new Triangle(newEdgeP_A, newEdgeP_2, oldEdgeA_2);
            Triangle newTriangleP_B_1 = new Triangle(newEdgeP_B, newEdgeP_1, oldEdgeB_1);
            Triangle newTriangleP_B_2 = new Triangle(newEdgeP_B, newEdgeP_2, oldEdgeB_2);
            newEdgeP_A.setFaceA(newTriangleP_A_1);
            newEdgeP_A.setFaceB(newTriangleP_A_2);
            newEdgeP_B.setFaceA(newTriangleP_B_1);
            newEdgeP_B.setFaceB(newTriangleP_B_2);
            newEdgeP_1.setFaceA(newTriangleP_A_1);
            newEdgeP_1.setFaceB(newTriangleP_B_1);
            newEdgeP_2.setFaceA(newTriangleP_A_2);
            newEdgeP_2.setFaceB(newTriangleP_B_2);
            oldEdgeA_1.setOtherFace(newTriangleP_A_1, farSideA_1);
            oldEdgeA_2.setOtherFace(newTriangleP_A_2, farSideA_2);
            oldEdgeB_1.setOtherFace(newTriangleP_B_1, farSideB_1);
            oldEdgeB_2.setOtherFace(newTriangleP_B_2, farSideB_2);
            shared.disconnect();
            triangleList.remove(borderA);
            triangleList.remove(borderB);
            triangleList.add(newTriangleP_A_1);
            triangleList.add(newTriangleP_A_2);
            triangleList.add(newTriangleP_B_1);
            triangleList.add(newTriangleP_B_2);
            LOGGER.finer("bordered " + borderA + " and " + borderB);
            LOGGER.finer("triangle list now is " + triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_A_1, oldEdgeA_1, newNode, triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_A_2, oldEdgeA_2, newNode, triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_B_1, oldEdgeB_1, newNode, triangleList);
            DelaunayTriangulator.legalizeEdge(newTriangleP_B_2, oldEdgeB_2, newNode, triangleList);
        } else {
            throw new RuntimeException("What the?  It isn't in any triangle or on any borders?");
        }
    }

    private static void legalizeEdge(Triangle t, DelaunayEdge e, DelaunayNode p, Vector triangleList) {
        LOGGER.fine("legalizing " + t + " and " + e.getOtherFace(t));
        if (DelaunayTriangulator.isIllegal(t, e, p)) {
            Triangle otherFace = e.getOtherFace(t);
            LOGGER.finer("switch internal edge");
            DelaunayNode fourthCorner = (DelaunayNode)otherFace.getThirdNode(e);
            DelaunayNode eNodeA = (DelaunayNode)e.getNodeA();
            DelaunayNode eNodeB = (DelaunayNode)e.getNodeB();
            DelaunayEdge edgeP_4 = new DelaunayEdge(p, fourthCorner);
            DelaunayEdge edgeP_A = (DelaunayEdge)t.getOppositeEdge(eNodeB);
            DelaunayEdge edgeP_B = (DelaunayEdge)t.getOppositeEdge(eNodeA);
            DelaunayEdge edgeA_4 = (DelaunayEdge)otherFace.getOppositeEdge(eNodeB);
            DelaunayEdge edgeB_4 = (DelaunayEdge)otherFace.getOppositeEdge(eNodeA);
            Triangle farSideP_A = edgeP_A.getOtherFace(t);
            Triangle farSideP_B = edgeP_B.getOtherFace(t);
            Triangle farSideA_4 = edgeA_4.getOtherFace(otherFace);
            Triangle farSideB_4 = edgeB_4.getOtherFace(otherFace);
            Triangle newTriangleP_A_4 = new Triangle(edgeP_A, edgeA_4, edgeP_4);
            Triangle newTriangleP_B_4 = new Triangle(edgeP_B, edgeB_4, edgeP_4);
            if (DelaunayTriangulator.rejectSwap(t, otherFace, newTriangleP_A_4, newTriangleP_B_4)) {
                LOGGER.finer("Rejected swap of " + t + " and " + otherFace);
            } else {
                edgeP_A.setOtherFace(newTriangleP_A_4, farSideP_A);
                edgeP_B.setOtherFace(newTriangleP_B_4, farSideP_B);
                edgeA_4.setOtherFace(newTriangleP_A_4, farSideA_4);
                edgeB_4.setOtherFace(newTriangleP_B_4, farSideB_4);
                edgeP_4.setFaceA(newTriangleP_A_4);
                edgeP_4.setFaceB(newTriangleP_B_4);
                e.disconnect();
                triangleList.remove(t);
                triangleList.remove(otherFace);
                triangleList.add(newTriangleP_A_4);
                triangleList.add(newTriangleP_B_4);
                LOGGER.finer("swapped " + t + " and " + otherFace);
                LOGGER.finer("new triangles are " + newTriangleP_A_4 + " and " + newTriangleP_B_4);
                LOGGER.finer("Triangle list now is: " + triangleList);
                DelaunayTriangulator.legalizeEdge(newTriangleP_A_4, edgeA_4, p, triangleList);
                DelaunayTriangulator.legalizeEdge(newTriangleP_B_4, edgeB_4, p, triangleList);
            }
        }
    }

    private static boolean isTemporary(DelaunayNode n) {
        return n.equals(temp1) || n.equals(temp2) || n.equals(temp3);
    }

    private static boolean isIllegal(Triangle t, DelaunayEdge e, DelaunayNode p) {
        DelaunayNode eNodeA = (DelaunayNode)e.getNodeA();
        DelaunayNode eNodeB = (DelaunayNode)e.getNodeB();
        if (DelaunayTriangulator.isTemporary(eNodeA) && DelaunayTriangulator.isTemporary(eNodeB)) {
            return false;
        }
        DelaunayNode farNode = (DelaunayNode)e.getOtherFace(t).getThirdNode(e);
        DelaunayEdge p_a = (DelaunayEdge)t.getOppositeEdge(e.getNodeB());
        DelaunayEdge p_b = (DelaunayEdge)t.getOppositeEdge(e.getNodeA());
        DelaunayNode farNodeP_A = (DelaunayNode)p_a.getOtherFace(t).getThirdNode(p_a);
        DelaunayNode farNodeP_B = (DelaunayNode)p_b.getOtherFace(t).getThirdNode(p_b);
        if (farNode.equals(farNodeP_A) || farNode.equals(farNodeP_B)) {
            return false;
        }
        int numTemporary = 0;
        if (DelaunayTriangulator.isTemporary(eNodeA)) {
            ++numTemporary;
        }
        if (DelaunayTriangulator.isTemporary(eNodeB)) {
            ++numTemporary;
        }
        if (DelaunayTriangulator.isTemporary(p)) {
            ++numTemporary;
        }
        if (DelaunayTriangulator.isTemporary(farNode)) {
            ++numTemporary;
        }
        if (numTemporary == 0) {
            Point2D.Double point;
            Ellipse2D.Double circum = DelaunayTriangulator.constructCircle(p, eNodeA, eNodeB);
            if (circum.contains(point = new Point2D.Double(farNode.getCoordinate().x, farNode.getCoordinate().y))) {
                LOGGER.finer("Illegal by case 2");
                return true;
            }
            return false;
        }
        if (numTemporary == 1) {
            if (DelaunayTriangulator.isTemporary(eNodeA) || DelaunayTriangulator.isTemporary(eNodeB)) {
                LOGGER.finer("Illegal by case 3");
                return true;
            }
            return false;
        }
        if (numTemporary == 2) {
            int j;
            int i = DelaunayTriangulator.whichSpecialNode(eNodeA, eNodeB);
            if (i < (j = DelaunayTriangulator.whichSpecialNode(p, farNode))) {
                return false;
            }
            LOGGER.finer("Illegal by case 4");
            return true;
        }
        throw new RuntimeException("Problem in DelaunayTriangulator.isIllegal--This shouldn't've happened!");
    }

    private static int whichSpecialNode(DelaunayNode a, DelaunayNode b) {
        if (a.equals(temp1) || b.equals(temp1)) {
            return 1;
        }
        if (a.equals(temp2) || b.equals(temp2)) {
            return 2;
        }
        if (a.equals(temp3) || b.equals(temp3)) {
            return 3;
        }
        throw new RuntimeException("I shouldn't be here.  Either node a or node b should be temporary.");
    }

    private static Ellipse2D.Double constructCircle(DelaunayNode a, DelaunayNode b, DelaunayNode c) {
        Point2D.Double midPointA_B = new Point2D.Double((a.getCoordinate().x + b.getCoordinate().x) / 2.0, (a.getCoordinate().y + b.getCoordinate().y) / 2.0);
        double deltaXA_B = a.getCoordinate().x - midPointA_B.getX();
        double deltaYA_B = a.getCoordinate().y - midPointA_B.getY();
        Line bisectorA_B = new Line();
        bisectorA_B.setLine((Point2D)new Point2D.Double(midPointA_B.getX() + 100.0 * deltaYA_B, midPointA_B.getY() - 100.0 * deltaXA_B), (Point2D)new Point2D.Double(midPointA_B.getX() - 100.0 * deltaYA_B, midPointA_B.getY() + 100.0 * deltaXA_B));
        Point2D.Double midPointA_C = new Point2D.Double((a.getCoordinate().x + c.getCoordinate().x) / 2.0, (a.getCoordinate().y + c.getCoordinate().y) / 2.0);
        double deltaXA_C = a.getCoordinate().x - midPointA_C.getX();
        double deltaYA_C = a.getCoordinate().y - midPointA_C.getY();
        Line bisectorA_C = new Line();
        Point2D intersection = null;
        int i = 1;
        do {
            bisectorA_C.setLine((Point2D)new Point2D.Double(midPointA_C.getX() + Math.pow(100.0, i) * deltaYA_C, midPointA_C.getY() - Math.pow(100.0, i) * deltaXA_C), (Point2D)new Point2D.Double(midPointA_C.getX() - Math.pow(100.0, i) * deltaYA_C, midPointA_C.getY() + Math.pow(100.0, i) * deltaXA_C));
            intersection = bisectorA_B.intersectionPoint(bisectorA_C);
            ++i;
        } while (intersection == null);
        double radius = intersection.distance(a.getCoordinate().x, a.getCoordinate().y);
        Ellipse2D.Double circle = new Ellipse2D.Double(intersection.getX() - radius, intersection.getY() - radius, 2.0 * radius, 2.0 * radius);
        return circle;
    }

    private static boolean rejectSwap(Triangle oldFirst, Triangle oldSecond, Triangle newFirst, Triangle newSecond) {
        double tolerance;
        double oldArea = oldFirst.getArea() + oldSecond.getArea();
        double newArea = newFirst.getArea() + newSecond.getArea();
        double diff = newArea - oldArea;
        return diff > (tolerance = 0.05);
    }

    static {
        LOGGER = Logger.getLogger("org.geotools.graph");
    }
}

