/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util.delaunay;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.line.XYNode;

public class GraphViewer
extends JPanel {
    Graph graph;
    Collection nodes;
    int minX;
    int minY;
    Color[] nodeColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};

    public void setGraph(Graph gr) {
        this.graph = gr;
        this.nodes = this.graph.getNodes();
        Iterator it = this.nodes.iterator();
        this.minX = 0;
        this.minY = 0;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof XYNode)) {
                throw new RuntimeException("I can't draw a node that doesn't have a coordinate.");
            }
            Coordinate coord = ((XYNode)next).getCoordinate();
            if (coord.x < (double)this.minX) {
                this.minX = (int)Math.round(coord.x);
            }
            if (!(coord.y < (double)this.minY)) continue;
            this.minY = (int)Math.round(coord.y);
        }
    }

    public void paintComponent(Graphics g) {
        boolean i = false;
        int scaling = 4;
        Iterator it = this.nodes.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof XYNode)) {
                throw new RuntimeException("I can't draw a node that doesn't have a coordinate.");
            }
            Coordinate coord = ((XYNode)next).getCoordinate();
            g.fillOval((int)Math.round(coord.x * (double)scaling - 2.0) - this.minX * scaling, (int)Math.round(coord.y * (double)scaling - 2.0) - this.minY * scaling, 4, 4);
        }
        g.setColor(Color.RED);
        Collection edges = this.graph.getEdges();
        Iterator edgeIt = edges.iterator();
        while (edgeIt.hasNext()) {
            Edge next = (Edge)edgeIt.next();
            if (!(next.getNodeA() instanceof XYNode) || !(next.getNodeB() instanceof XYNode)) {
                throw new RuntimeException("I can't draw an edge without endpoint coordinates.");
            }
            Coordinate coordA = ((XYNode)next.getNodeA()).getCoordinate();
            Coordinate coordB = ((XYNode)next.getNodeB()).getCoordinate();
            g.drawLine((int)Math.round(coordA.x * (double)scaling) - this.minX * scaling, (int)Math.round(coordA.y * (double)scaling) - this.minY * scaling, (int)Math.round(coordB.x * (double)scaling) - this.minX * scaling, (int)Math.round(coordB.y * (double)scaling) - this.minY * scaling);
        }
    }
}

