/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.validation.Validation;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.xml.ValidationException;

public class PlugIn {
    Map defaults;
    String plugInName;
    String plugInDescription;
    BeanInfo beanInfo;
    Map propertyMap;

    PlugIn(Map config) throws ValidationException {
        this(PlugIn.get(config, "name"), PlugIn.get(config, "bean", Validation.class), PlugIn.get(config, "description"), config);
    }

    public PlugIn(String name, Class type, String description, Map config) throws ValidationException {
        if (type == null || !Validation.class.isAssignableFrom(type) && type.isInterface()) {
            throw new ValidationException("Not a validation test '" + name + "' plugIn:" + type);
        }
        try {
            this.beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ValidationException("Could not use the '" + name + "' plugIn:" + type.getName());
        }
        if (config != null) {
            this.defaults = this.transArgs(config);
        }
        this.plugInName = name;
        this.plugInDescription = description;
        this.propertyMap = PlugIn.propertyMap(this.beanInfo);
    }

    private Map transArgs(Map config) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        Iterator i = config.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object o = config.get(key);
            if (o instanceof ArgumentDTO) {
                defaults.put(key, ((ArgumentDTO)o).getValue());
                continue;
            }
            defaults.put(key, o);
        }
        return defaults;
    }

    protected PropertyDescriptor propertyInfo(String name) {
        return (PropertyDescriptor)this.propertyMap.get(name);
    }

    protected static Map propertyMap(BeanInfo info) {
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> lookup = new HashMap<String, PropertyDescriptor>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            lookup.put(properties[i].getName(), properties[i]);
        }
        return lookup;
    }

    public Validation createValidation(String name, String description, Map args) throws ValidationException {
        Validation validate;
        Constructor<?> create;
        BeanDescriptor beanDescriptor = this.beanInfo.getBeanDescriptor();
        Class<?> type = beanDescriptor.getBeanClass();
        try {
            create = type.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new ValidationException("Could not create '" + this.plugInName + "' as " + type.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ValidationException("Could not create '" + this.plugInName + "' as " + type.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Could not create '" + this.plugInName + "' as " + type.getName(), e);
        }
        try {
            validate = (Validation)create.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ValidationException("Could not create '" + name + "' as plugIn " + this.plugInName, e);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Could not create '" + name + "' as plugIn " + this.plugInName, e);
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Could not create '" + name + "' as plugIn " + this.plugInName, e);
        }
        validate.setName(name);
        validate.setDescription(description);
        this.configure(validate, this.defaults);
        this.configure(validate, this.transArgs(args));
        return validate;
    }

    protected void configure(Object bean, Map config) throws ValidationException {
        if (config == null || config.size() == 0) {
            return;
        }
        Iterator i = config.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            PropertyDescriptor property = this.propertyInfo((String)entry.getKey());
            if (property == null) continue;
            try {
                property.getWriteMethod().invoke(bean, entry.getValue());
            }
            catch (IllegalArgumentException e) {
                String val = entry.getValue() == null ? entry.getValue().toString() : "null";
                throw new ValidationException("test failed to configure " + this.plugInName + " " + entry.getKey() + " " + val, e);
            }
            catch (IllegalAccessException e) {
                String val = entry.getValue() == null ? entry.getValue().toString() : "null";
                throw new ValidationException("test failed to configure " + this.plugInName + " " + entry.getKey() + " " + val, e);
            }
            catch (InvocationTargetException e) {
                String val = entry.getValue() == null ? entry.getValue().toString() : "null";
                throw new ValidationException("test failed to configure " + this.plugInName + " " + entry.getKey() + " " + val, e);
            }
        }
    }

    private static String get(Map map, String key) {
        if (map.containsKey(key)) {
            return (String)map.get(key);
        }
        return null;
    }

    private static Class get(Map map, String key, Class defaultType) {
        if (!map.containsKey(key)) {
            return defaultType;
        }
        Object value = map.get(key);
        if (value instanceof Class) {
            return (Class)value;
        }
        if (value instanceof String) {
            try {
                return Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return defaultType;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }
}

