/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Repository;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.validation.Validation;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.ValidationResults;

public class Validator {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    private ValidationProcessor validationProcessor;
    private Repository repository;

    public Validator(Repository repository, ValidationProcessor processor) {
        this.repository = repository;
        this.validationProcessor = processor;
    }

    public void featureValidation(String dsid, FeatureReader features, ValidationResults results) throws IOException, Exception {
        if (this.validationProcessor == null) {
            LOGGER.warning("ValidationProcessor unavailable");
            return;
        }
        FeatureType type = features.getFeatureType();
        TreeMap failed = new TreeMap();
        try {
            this.validationProcessor.runFeatureTests(dsid, type, features, results);
        }
        catch (Exception badIdea) {
            throw new DataSourceException("Validation Failed", badIdea);
        }
    }

    private ValidationResults makeFeatureValidationResults(final Map failed) {
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
            }

            public void warning(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        return results;
    }

    public void integrityValidation(Map featureStores, Envelope bBox, ValidationResults results) throws IOException, Exception {
        if (this.validationProcessor == null) {
            LOGGER.warning("Validation Processor unavaialble");
            return;
        }
        LOGGER.finer("Required to validate " + featureStores.size() + " typeRefs");
        LOGGER.finer("within " + bBox);
        HashSet<String> typeRefs = new HashSet<String>();
        Iterator i = featureStores.keySet().iterator();
        while (i.hasNext()) {
            String typeRef = (String)i.next();
            typeRefs.add(typeRef);
            Set dependencies = this.validationProcessor.getDependencies(typeRef);
            LOGGER.finer("typeRef " + typeRef + " requires " + dependencies);
            if (dependencies == null || dependencies.size() <= 0) continue;
            typeRefs.addAll(dependencies);
        }
        HashMap sources = new HashMap();
        Iterator i2 = typeRefs.iterator();
        while (i2.hasNext()) {
            String typeRef = (String)i2.next();
            LOGGER.finer("Searching for required typeRef: " + typeRef);
            if (featureStores.containsKey(typeRef)) {
                LOGGER.finer(" found required typeRef: " + typeRef + " (it was already loaded)");
                sources.put(typeRef, featureStores.get(typeRef));
                continue;
            }
            LOGGER.finer(" could not find typeRef: " + typeRef + " (we will now load it)");
            String[] split = typeRef.split(":");
            String dataStoreId = split[0];
            String typeName = split[1];
            LOGGER.finer(" going to look for dataStoreId:" + dataStoreId + " and typeName:" + typeName);
            LOGGER.finer(" loaded required typeRef: " + typeRef);
            FeatureSource source = this.repository.source(dataStoreId, typeName);
            sources.put(typeRef, source);
        }
        LOGGER.finer("Total of " + sources.size() + " featureSource marshalled for testing");
        TreeMap failed = new TreeMap();
        try {
            LOGGER.finer("Runing integrity tests using validation validationProcessor ");
            this.validationProcessor.runIntegrityTests(featureStores.keySet(), sources, bBox, results);
        }
        catch (Exception badIdea) {
            badIdea.printStackTrace();
            throw new DataSourceException("Validation Failed", badIdea);
        }
        if (failed.isEmpty()) {
            LOGGER.finer("All validation tests passed");
            return;
        }
        LOGGER.finer("Validation fail - marshal result for transaction document");
        StringBuffer message = new StringBuffer();
        Iterator i3 = failed.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = i3.next();
            message.append(entry.getKey());
            message.append(" failed test ");
            message.append(entry.getValue());
            message.append("\n");
        }
    }

    private ValidationResults makeIntegrityValidationResults(final Map failed) {
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                if (feature == null) {
                    failed.put("ALL", this.name + ": " + message + " " + "(" + this.description + ")");
                } else {
                    failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
                }
            }

            public void warning(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        return results;
    }
}

