/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;

public class EqualityValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.validation");
    private String attributeName;
    private Object expected;
    private Filter filter = Filter.NONE;

    public int getPriority() {
        return 200;
    }

    public String[] getTypeRefs() {
        if (this.getTypeRef() == null) {
            return null;
        }
        if (this.getTypeRef().equals("*")) {
            return ALL;
        }
        return new String[]{this.getTypeRef()};
    }

    public boolean validate(Feature feature, FeatureType type, ValidationResults results) {
        if (!this.filter.contains(feature)) {
            return true;
        }
        Object actual = feature.getAttribute(this.attributeName);
        if (this.expected.equals(actual)) {
            return true;
        }
        results.error(feature, this.attributeName + " did not not equals " + this.expected);
        return false;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Object getExpected() {
        return this.expected;
    }

    public void setExpected(Object expected) {
        this.expected = expected;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

