/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GazetteerNameValidation
extends DefaultFeatureValidation {
    private URL gazetteer;
    private String attributeName;

    public GazetteerNameValidation() {
        try {
            this.gazetteer = new URL("http://cgdi-dev.geoconnections.org/cgi-bin/prototypes/cgdigaz/cgdigaz.cgi?version=1.0&request=GetPlacenameGeometry&wildcards=false&geomtype=bbox");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public boolean validate(Feature feature, FeatureType type, ValidationResults results) {
        int number;
        String place = (String)feature.getAttribute(this.attributeName);
        URL gazetteerURL = null;
        try {
            gazetteerURL = new URL(this.gazetteer.toString() + "&placename=" + place);
        }
        catch (MalformedURLException e) {
            results.error(feature, e.toString());
            return false;
        }
        InputStream gazetteerInputStream = null;
        try {
            HttpURLConnection gazetteerConnection = (HttpURLConnection)gazetteerURL.openConnection();
            if (!"OK".equals(gazetteerConnection.getResponseMessage())) {
                results.error(feature, "An error occured creating the connection to the Gazetteer.");
            }
            gazetteerInputStream = gazetteerConnection.getInputStream();
        }
        catch (IOException e) {
            results.error(feature, e.toString());
            return false;
        }
        InputStreamReader gazetteerInputStreamReader = new InputStreamReader(gazetteerInputStream);
        BufferedReader gazetteerBufferedReader = new BufferedReader(gazetteerInputStreamReader);
        InputSource gazetteerInputSource = new InputSource(gazetteerBufferedReader);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        dfactory.setIgnoringComments(true);
        dfactory.setCoalescing(true);
        dfactory.setIgnoringElementContentWhitespace(true);
        Document serviceDoc = null;
        try {
            serviceDoc = dfactory.newDocumentBuilder().parse(gazetteerInputSource);
        }
        catch (Exception e) {
            results.error(feature, e.toString());
        }
        Element elem = serviceDoc.getDocumentElement();
        elem = GazetteerNameValidation.getChildElement(elem, "queryInfo");
        if (elem == null) {
            results.error(feature, "Invalid DOM tree returned by gazetteer.");
        }
        return (number = Integer.parseInt(GazetteerNameValidation.getChildText(elem, "numberOfResults"))) > 0;
    }

    public int getPriority() {
        return 5;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attrName) {
        this.attributeName = attrName;
    }

    public URL getGazetteer() {
        return this.gazetteer;
    }

    public void setGazetteer(URL gazetteer) {
        this.gazetteer = gazetteer;
    }

    private static Element getChildElement(Element root, String name) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    private static String getChildText(Element root, String childName) {
        Element elem = GazetteerNameValidation.getChildElement(root, childName);
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int nChilds = childs.getLength();
            for (int i = 0; i < nChilds; ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue();
            }
        }
        return null;
    }
}

