/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;

public class UniqueFIDValidation
extends DefaultIntegrityValidation {
    String typeRef;

    public int getPriority() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        HashMap<String, String> FIDs = new HashMap<String, String>();
        boolean result = true;
        Iterator it = layers.values().iterator();
        while (it.hasNext()) {
            FeatureSource featureSource = (FeatureSource)it.next();
            FeatureReader reader = featureSource.getFeatures().reader();
            try {
                while (reader.hasNext()) {
                    Feature feature = reader.next();
                    String fid = feature.getID();
                    if (FIDs.containsKey(fid)) {
                        results.error(feature, "FID already exists.");
                        result = false;
                        continue;
                    }
                    FIDs.put(fid, fid);
                }
            }
            finally {
                reader.close();
            }
        }
        return result;
    }

    public String[] getTypeRefs() {
        if (this.typeRef == null) {
            return null;
        }
        if (this.typeRef.equals("*")) {
            return new String[0];
        }
        return new String[]{this.typeRef};
    }

    public String getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(String typeRef) {
        this.typeRef = typeRef;
    }
}

