/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.network;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.graph.build.line.LineStringGraphGenerator;
import org.geotools.graph.structure.Graph;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;

public class OrphanNodeValidation
extends DefaultIntegrityValidation {
    private String typeName;

    public String[] getTypeRefs() {
        return new String[]{this.typeName};
    }

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LineStringGraphGenerator lgb = new LineStringGraphGenerator();
        FeatureSource fs = (FeatureSource)layers.get(this.typeName);
        FeatureCollection fr = fs.getFeatures();
        FeatureCollection fc = fr.collection();
        FeatureIterator f = fc.features();
        while (f.hasNext()) {
            Feature ft = f.next();
            if (!envelope.contains(ft.getBounds())) continue;
            lgb.add((Object)ft.getDefaultGeometry());
        }
        Graph g = lgb.getGraph();
        return g.getNodesOfDegree(0).size() == 0;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

