/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;

public class DisjointIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.validation");

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up FeatureSource ");
        FeatureSource geomSource1 = (FeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + geomSource1.getSchema().getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.finer(typeRef2 + ": looking up FeatureSource ");
        FeatureSource geomSource2 = (FeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + geomSource2.getSchema().getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateMultipleLayers(FeatureSource featureSourceA, FeatureSource featureSourceB, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        FeatureReader fr2;
        FeatureReader fr1;
        FeatureCollection featureResultsB;
        boolean success;
        block9: {
            success = true;
            FilterFactory ff = FilterFactoryFinder.createFilterFactory();
            Filter filter = null;
            FeatureCollection featureResultsA = featureSourceA.getFeatures(filter);
            featureResultsB = featureSourceB.getFeatures(filter);
            fr1 = null;
            fr2 = null;
            fr1 = featureResultsA.reader();
            if (fr1 != null) break block9;
            boolean bl = false;
            Object var18_15 = null;
            try {
                fr1.close();
                if (fr2 == null) return bl;
                fr2.close();
                return bl;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
        }
        try {
            while (fr1.hasNext()) {
                Feature f1 = fr1.next();
                Geometry g1 = f1.getDefaultGeometry();
                fr2 = featureResultsB.reader();
                while (fr2 != null && fr2.hasNext()) {
                    Feature f2 = fr2.next();
                    Geometry g2 = f2.getDefaultGeometry();
                    if (g1.disjoint(g2) == expected) continue;
                    results.error(f1, f1.getDefaultGeometry().getGeometryType() + " " + this.getGeomTypeRefA() + " is disjoint from " + this.getGeomTypeRefB() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
            }
            Object var18_16 = null;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            try {
                fr1.close();
                if (fr2 == null) throw throwable;
                fr2.close();
                throw throwable;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
        }
        try {
            fr1.close();
            if (fr2 == null) return success;
            fr2.close();
            return success;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            throw e4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateSingleLayer(FeatureSource featureSourceA, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        FeatureReader fr2;
        FeatureReader fr1;
        FeatureCollection featureResults;
        boolean success;
        block9: {
            success = true;
            FilterFactory ff = FilterFactoryFinder.createFilterFactory();
            Filter filter = null;
            featureResults = featureSourceA.getFeatures(filter);
            fr1 = null;
            fr2 = null;
            fr1 = featureResults.reader();
            if (fr1 != null) break block9;
            boolean bl = false;
            Object var16_13 = null;
            try {
                fr1.close();
                if (fr2 == null) return bl;
                fr2.close();
                return bl;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
        }
        try {
            while (fr1.hasNext()) {
                Feature f1 = fr1.next();
                Geometry g1 = f1.getDefaultGeometry();
                fr2 = featureResults.reader();
                while (fr2 != null && fr2.hasNext()) {
                    Feature f2 = fr2.next();
                    Geometry g2 = f2.getDefaultGeometry();
                    if (f1.getID().equals(f2.getID()) || g1.disjoint(g2) == expected) continue;
                    results.error(f1, f1.getDefaultGeometry().getGeometryType() + " " + this.getGeomTypeRefA() + " is disjoint from " + this.getGeomTypeRefA() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
            }
            Object var16_14 = null;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            try {
                fr1.close();
                if (fr2 == null) throw throwable;
                fr2.close();
                throw throwable;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
        }
        try {
            fr1.close();
            if (fr2 == null) return success;
            fr2.close();
            return success;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            throw e4;
        }
    }
}

