/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;

public class OverlapsIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.validation");
    private static HashSet usedIDs;
    private boolean showPrintLines = true;

    public OverlapsIntegrity() {
        usedIDs = new HashSet();
    }

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up FeatureSource");
        FeatureSource geomSource1 = (FeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + geomSource1.getSchema().getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.warning(typeRef2 + ": looking up FeatureSource ");
        FeatureSource geomSource2 = (FeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + geomSource2.getSchema().getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateMultipleLayers(FeatureSource featureSourceA, FeatureSource featureSourceB, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        FeatureReader fr2;
        FeatureReader fr1;
        boolean success;
        block17: {
            boolean bl;
            block16: {
                success = true;
                int errors = 0;
                int countInterval = 100;
                int counter = 0;
                FeatureType ft = featureSourceA.getSchema();
                Filter filter = OverlapsIntegrity.filterBBox(bBox, ft);
                FeatureCollection featureResults = featureSourceA.getFeatures();
                fr1 = null;
                fr2 = null;
                try {
                    fr1 = featureResults.reader();
                    if (fr1 == null) {
                        bl = success;
                        Object var23_17 = null;
                        break block16;
                    }
                    while (fr1.hasNext()) {
                        ++counter;
                        Feature f1 = fr1.next();
                        Geometry g1 = f1.getDefaultGeometry();
                        Filter filter2 = OverlapsIntegrity.filterBBox(g1.getEnvelope().getEnvelopeInternal(), ft);
                        FeatureCollection featureResults2 = featureSourceB.getFeatures(filter2);
                        fr2 = featureResults2.reader();
                        try {
                            while (fr2 != null && fr2.hasNext()) {
                                Feature f2 = fr2.next();
                                Geometry g2 = f2.getDefaultGeometry();
                                if (usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.overlaps(g2) == expected && g1.contains(g2) == expected) continue;
                                results.error(f1, this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefB() + "(" + f2.getID() + ")");
                                if (this.showPrintLines) {
                                    // empty if block
                                }
                                success = false;
                                ++errors;
                            }
                            usedIDs.add(f1.getID());
                            if (counter % countInterval != 0 || !this.showPrintLines) continue;
                            System.out.println("count: " + counter);
                        }
                        finally {
                            if (fr2 == null) continue;
                            fr2.close();
                        }
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var23_19 = null;
                    try {
                        if (fr1 != null) {
                            fr1.close();
                        }
                        if (fr2 == null) throw throwable;
                        fr2.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                        throw e4;
                    }
                }
            }
            try {}
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
            if (fr1 != null) {
                fr1.close();
            }
            if (fr2 == null) return bl;
            fr2.close();
            return bl;
        }
        Object var23_18 = null;
        try {}
        catch (IOException e4) {
            e4.printStackTrace();
            throw e4;
        }
        if (fr1 != null) {
            fr1.close();
        }
        if (fr2 == null) return success;
        fr2.close();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSingleLayer(FeatureSource featureSourceA, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        FeatureReader fr2;
        FeatureReader fr1;
        Date date1;
        int errors;
        boolean success;
        block23: {
            Date date22;
            boolean bl;
            block22: {
                success = true;
                errors = 0;
                date1 = new Date();
                int countInterval = 100;
                int counter = 0;
                FeatureType ft = featureSourceA.getSchema();
                System.out.println("---------------- In Overlaps Integrity ----------------");
                FeatureCollection featureResults = null;
                if (bBox != null && !bBox.isNull() && bBox.getHeight() != 0.0 && bBox.getWidth() != 0.0) {
                    Filter filter = OverlapsIntegrity.filterBBox(bBox, ft);
                    featureResults = featureSourceA.getFeatures(filter);
                } else {
                    featureResults = featureSourceA.getFeatures();
                }
                fr1 = null;
                fr2 = null;
                try {
                    fr1 = featureResults.reader();
                    if (fr1 == null) {
                        bl = success;
                        Object var22_16 = null;
                        date22 = new Date();
                        break block22;
                    }
                    while (fr1.hasNext()) {
                        ++counter;
                        Feature f1 = fr1.next();
                        Geometry g1 = f1.getDefaultGeometry();
                        Filter filter2 = OverlapsIntegrity.filterBBox(g1.getEnvelope().getEnvelopeInternal(), ft);
                        FeatureCollection featureResults2 = featureSourceA.getFeatures(filter2);
                        fr2 = featureResults2.reader();
                        try {
                            while (fr2 != null && fr2.hasNext()) {
                                Feature f2 = fr2.next();
                                Geometry g2 = f2.getDefaultGeometry();
                                if (usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.relate(g2, "1********") == expected) continue;
                                if (results != null) {
                                    results.error(f1, "" + this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefA() + "(" + f2.getID() + ")");
                                }
                                if (this.showPrintLines) {
                                    // empty if block
                                }
                                success = false;
                                ++errors;
                            }
                            usedIDs.add(f1.getID());
                        }
                        finally {
                            if (fr2 == null) continue;
                            fr2.close();
                        }
                    }
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var22_18 = null;
                    Date date22 = new Date();
                    float dt = date22.getTime() - date1.getTime();
                    if (this.showPrintLines) {
                        System.out.println("########## Validation duration: " + dt);
                        System.out.println("########## Validation errors: " + errors);
                    }
                    try {
                        if (fr1 != null) {
                            fr1.close();
                        }
                        if (fr2 == null) throw throwable;
                        fr2.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                        throw e4;
                    }
                }
            }
            float dt = date22.getTime() - date1.getTime();
            if (this.showPrintLines) {
                System.out.println("########## Validation duration: " + dt);
                System.out.println("########## Validation errors: " + errors);
            }
            try {}
            catch (IOException e4) {
                e4.printStackTrace();
                throw e4;
            }
            if (fr1 != null) {
                fr1.close();
            }
            if (fr2 == null) return bl;
            fr2.close();
            return bl;
        }
        Object var22_17 = null;
        Date date22 = new Date();
        float dt = date22.getTime() - date1.getTime();
        if (this.showPrintLines) {
            System.out.println("########## Validation duration: " + dt);
            System.out.println("########## Validation errors: " + errors);
        }
        try {}
        catch (IOException e4) {
            e4.printStackTrace();
            throw e4;
        }
        if (fr1 != null) {
            fr1.close();
        }
        if (fr2 == null) return success;
        fr2.close();
        return success;
    }

    public static Filter filterBBox(Envelope bBox, FeatureType ft) throws FactoryConfigurationError, IllegalFilterException {
        if (bBox == null) {
            return Filter.NONE;
        }
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        BBoxExpression bboxExpr = ff.createBBoxExpression(bBox);
        AttributeExpression geomExpr = ff.createAttributeExpression(ft, ft.getDefaultGeometry().getName());
        GeometryFilter disjointFilter = ff.createGeometryFilter((short)6);
        disjointFilter.addLeftGeometry(geomExpr);
        disjointFilter.addRightGeometry(bboxExpr);
        Filter filter = disjointFilter.not();
        return filter;
    }
}

