/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.TempFeatureResults;

public class SpatialTestCase
extends TestCase {
    protected GeometryFactory gf;
    protected FeatureType lineType;
    protected Feature[] lineFeatures;
    protected Envelope lineBounds;
    protected LineString ls0;
    protected LineString ls1;
    protected LineString ls2;
    protected LineString ls3;
    protected String namespace;
    protected FilterFactory filterFactory;
    protected Filter lineFilter;
    MemoryDataStore mds;
    ValidationResults vr;

    public SpatialTestCase(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        this.gf = new GeometryFactory();
        this.mds = new MemoryDataStore();
        this.namespace = this.getName();
        this.vr = new TempFeatureResults();
        this.lineFeatures = new Feature[4];
        this.ls0 = this.gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(2.0, 0.1), new Coordinate(3.0, 0.0), new Coordinate(4.0, 0.0)});
        this.ls1 = this.gf.createLineString(new Coordinate[]{new Coordinate(0.0, 2.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(1.0, -1.0)});
        this.ls2 = this.gf.createLineString(new Coordinate[]{new Coordinate(2.6, 2.0), new Coordinate(2.5, 1.0), new Coordinate(2.5, -1.0)});
        this.ls3 = this.gf.createLineString(new Coordinate[]{new Coordinate(3.0, 0.0), new Coordinate(4.0, 0.0), new Coordinate(5.0, 0.1)});
        this.lineType = DataUtilities.createType((String)"my.line", (String)"id:0,geom:LineString,name:String");
        this.lineFeatures[0] = this.lineType.create(new Object[]{new Integer(0), this.ls0, "line0"}, "line.line0");
        this.lineFeatures[1] = this.lineType.create(new Object[]{new Integer(1), this.ls1, "line1"}, "line.line1");
        this.lineFeatures[2] = this.lineType.create(new Object[]{new Integer(2), this.ls2, "line2"}, "line.line2");
        this.lineFeatures[3] = this.lineType.create(new Object[]{new Integer(3), this.ls3, "line3"}, "line.line3");
        this.lineBounds = new Envelope();
        this.lineBounds.expandToInclude(this.lineFeatures[0].getBounds());
        this.lineBounds.expandToInclude(this.lineFeatures[1].getBounds());
        this.lineBounds.expandToInclude(this.lineFeatures[2].getBounds());
        this.lineBounds.expandToInclude(this.lineFeatures[3].getBounds());
        this.mds.addFeature(this.lineFeatures[0]);
        this.mds.addFeature(this.lineFeatures[1]);
        this.mds.addFeature(this.lineFeatures[2]);
        this.mds.addFeature(this.lineFeatures[3]);
    }

    protected void tearDown() throws Exception {
        this.gf = null;
        this.lineType = null;
        this.lineFeatures = null;
        this.lineBounds = null;
        this.ls0 = null;
        this.ls1 = null;
        this.ls2 = null;
        this.ls3 = null;
        this.namespace = null;
        this.vr = null;
    }
}

