/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LinePolygonAbstractValidation;

public class LineCoveredByPolygonBoundaryValidation
extends LinePolygonAbstractValidation {
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        FeatureCollection frLine = fsLine.getFeatures();
        FeatureCollection fcLine = frLine.collection();
        FeatureIterator fLine = fcLine.features();
        FeatureSource fsPoly = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        FeatureCollection frPoly = fsPoly.getFeatures();
        FeatureCollection fcPoly = frPoly.collection();
        while (fLine.hasNext()) {
            Feature line = fLine.next();
            FeatureIterator fPoly = fcPoly.features();
            Geometry lineGeom = line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if ((class$com$vividsolutions$jts$geom$LineString == null ? LineCoveredByPolygonBoundaryValidation.class$("com.vividsolutions.jts.geom.LineString") : class$com$vividsolutions$jts$geom$LineString).isAssignableFrom(lineGeom.getClass())) {
                while (fPoly.hasNext()) {
                    Feature poly = fPoly.next();
                    Geometry polyGeom = poly.getDefaultGeometry();
                    if (envelope.contains(polyGeom.getEnvelopeInternal())) {
                        if ((class$com$vividsolutions$jts$geom$Polygon == null ? LineCoveredByPolygonBoundaryValidation.class$("com.vividsolutions.jts.geom.Polygon") : class$com$vividsolutions$jts$geom$Polygon).isAssignableFrom(polyGeom.getClass())) {
                            Geometry polyGeomBoundary = polyGeom.getBoundary();
                            if (polyGeomBoundary.contains(lineGeom)) continue;
                            results.error(poly, "Boundary does not contain the specified Line.");
                            r = false;
                            continue;
                        }
                        fcPoly.remove(poly);
                        results.warning(poly, "Invalid type: this feature is not a derivative of a Polygon");
                        continue;
                    }
                    fcPoly.remove(poly);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }

    public int getPriority() {
        return 200;
    }
}

