/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineAbstractValidation;

public class LineNoPseudoNodeValidation
extends LineAbstractValidation {
    private int degreesAllowable;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        FeatureCollection frLine = fsLine.getFeatures();
        FeatureCollection fcLine = frLine.collection();
        FeatureIterator fLine = fcLine.features();
        while (fLine.hasNext()) {
            Feature line = fLine.next();
            Geometry lineGeom = line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if ((class$com$vividsolutions$jts$geom$LineString == null ? LineNoPseudoNodeValidation.class$("com.vividsolutions.jts.geom.LineString") : class$com$vividsolutions$jts$geom$LineString).isAssignableFrom(lineGeom.getClass())) {
                Coordinate[] c = lineGeom.getCoordinates();
                int i = 0;
                while (i + 2 < c.length) {
                    LineSegment ls1 = new LineSegment(c[i], c[i + 1]);
                    LineSegment ls2 = new LineSegment(c[i + 1], c[i + 2]);
                    double a1 = ls1.angle();
                    double a2 = ls2.angle();
                    if (a1 - (double)this.degreesAllowable < a1 && a1 + (double)this.degreesAllowable > a2) continue;
                    results.error(line, "Atleast one node was too close to the other the perpendicular line between the node's two neighbours.");
                    i = c.length;
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }

    public int getDegreesAllowable() {
        return this.degreesAllowable;
    }

    public void setDegreesAllowable(int degreesAllowable) {
        this.degreesAllowable = degreesAllowable;
    }
}

