/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;

public class LineNoSelfOverlappingValidation
extends DefaultFeatureValidation {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.validation");

    public LineNoSelfOverlappingValidation() {
        System.out.println("***************** LineNoSelfOverlappingValidation *************");
    }

    public int getPriority() {
        return 1000;
    }

    public boolean validate(Feature feature, FeatureType type, ValidationResults results) {
        int i;
        LOGGER.setLevel(Level.ALL);
        LineString line = null;
        try {
            line = this.getDefaultLineString(feature);
        }
        catch (ClassCastException unLine) {
            results.error(feature, "Geometry is required to be a LineString");
            System.out.println(feature.getID() + "  name: " + this.getName());
            System.out.println(feature.getID() + "   ref: " + this.getTypeRef());
            System.out.println(feature.getID() + "   ref: " + this.getTypeRefs());
        }
        if (line == null) {
            return true;
        }
        if (line.getNumPoints() < 2) {
            results.warning(feature, "LineString contains too few points");
            return false;
        }
        GeometryFactory gf = new GeometryFactory();
        int numPoints = line.getNumPoints();
        LineString[] segments = new LineString[numPoints - 1];
        for (i = 0; i < numPoints - 1; ++i) {
            Coordinate[] coords = new Coordinate[]{line.getCoordinateN(i), line.getCoordinateN(i + 1)};
            segments[i] = gf.createLineString(coords);
        }
        for (i = 0; i < segments.length; ++i) {
            for (int j = 0; j < segments.length; ++j) {
                if (i == j || !segments[i].relate((Geometry)segments[j], "1********")) continue;
                results.error(feature, "LineString overlapped itself.");
                return false;
            }
        }
        return true;
    }

    private boolean touchesSegment(LineString[] segments, Point p1) {
        for (int i = 0; i < segments.length; ++i) {
            if (!p1.intersects((Geometry)segments[i])) continue;
            return true;
        }
        return false;
    }
}

