/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LinePolygonAbstractValidation;

public class LineNotTouchingPolygonInteriorValidation
extends LinePolygonAbstractValidation {
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        if (fsLine == null) {
            return true;
        }
        FeatureCollection frLine = fsLine.getFeatures();
        FeatureCollection fcLine = frLine.collection();
        FeatureIterator fLine = fcLine.features();
        FeatureSource fsPoly = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        if (fsPoly == null) {
            return true;
        }
        FeatureCollection frPoly = fsPoly.getFeatures();
        FeatureCollection fcPoly = frPoly.collection();
        while (fLine.hasNext()) {
            Feature line = fLine.next();
            FeatureIterator fPoly = fcPoly.features();
            Geometry lineGeom = line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if ((class$com$vividsolutions$jts$geom$LineString == null ? LineNotTouchingPolygonInteriorValidation.class$("com.vividsolutions.jts.geom.LineString") : class$com$vividsolutions$jts$geom$LineString).isAssignableFrom(lineGeom.getClass())) {
                while (fPoly.hasNext()) {
                    Feature poly = fPoly.next();
                    Geometry polyGeom = poly.getDefaultGeometry();
                    if (envelope.contains(polyGeom.getEnvelopeInternal())) {
                        if ((class$com$vividsolutions$jts$geom$Polygon == null ? LineNotTouchingPolygonInteriorValidation.class$("com.vividsolutions.jts.geom.Polygon") : class$com$vividsolutions$jts$geom$Polygon).isAssignableFrom(polyGeom.getClass())) {
                            Polygon p = (Polygon)polyGeom;
                            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                                if (p.getInteriorRingN(i).touches(lineGeom)) continue;
                                results.error(poly, "Polygon interior touches the specified Line.");
                            }
                            continue;
                        }
                        fcPoly.remove(poly);
                        results.warning(poly, "Invalid type: this feature is not a derivative of a Polygon");
                        continue;
                    }
                    fcPoly.remove(poly);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }
}

