/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;

public class LinesNotIntersectValidation
extends LineLineAbstractValidation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        boolean result = true;
        Iterator it = layers.values().iterator();
        while (it.hasNext()) {
            FeatureSource featureSource = (FeatureSource)it.next();
            FeatureReader reader = featureSource.getFeatures().reader();
            try {
                while (reader.hasNext()) {
                    Feature feature = reader.next();
                    Geometry geom = feature.getDefaultGeometry();
                    for (int i = 0; i < geoms.size(); ++i) {
                        if (!geom.crosses((Geometry)geoms.get(i))) continue;
                        results.error(feature, "Lines cross when they shouldn't.");
                        result = false;
                    }
                    geoms.add(geom);
                }
            }
            finally {
                reader.close();
            }
        }
        return result;
    }

    public int getPriority() {
        return 10000;
    }
}

