/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointLineAbstractValidation;

public class PointCoveredByLineValidation
extends PointLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource lineSource = (FeatureSource)layers.get(this.getRestrictedLineTypeRef());
        FeatureSource pointSource = (FeatureSource)layers.get(this.getPointTypeRef());
        Object[] points = pointSource.getFeatures().collection().toArray();
        Object[] lines = lineSource.getFeatures().collection().toArray();
        if (!envelope.contains(pointSource.getBounds())) {
            results.error((Feature)points[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains(lineSource.getBounds())) {
            results.error((Feature)lines[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < lines.length; ++i) {
            Feature tmp = (Feature)lines[i];
            Geometry gt = tmp.getDefaultGeometry();
            if (!(gt instanceof LineString)) continue;
            LineString ls = (LineString)gt;
            boolean r = false;
            for (int j = 0; j < points.length && !r; ++j) {
                Point pt;
                Feature tmp2 = (Feature)points[j];
                Geometry gt2 = tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Point) || ls.contains((Geometry)(pt = (Point)gt2))) continue;
                r = true;
            }
            if (r) continue;
            results.error(tmp, "Line does not contained one of the specified points.");
            return false;
        }
        return true;
    }
}

