/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PointPolygonAbstractValidation;

public class PointCoveredByPolygonBoundaryValidation
extends PointPolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource pointSource = (FeatureSource)layers.get(this.getPointTypeRef());
        FeatureSource polySource = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        Object[] polys = polySource.getFeatures().collection().toArray();
        Object[] points = pointSource.getFeatures().collection().toArray();
        if (!envelope.contains(polySource.getBounds())) {
            results.error((Feature)polys[0], "Point Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains(pointSource.getBounds())) {
            results.error((Feature)points[0], "Line Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < points.length; ++i) {
            Feature tmp = (Feature)points[i];
            Geometry gt = tmp.getDefaultGeometry();
            if (!(gt instanceof Polygon)) continue;
            Polygon ls = (Polygon)gt;
            boolean r = false;
            for (int j = 0; j < polys.length && !r; ++j) {
                Feature tmp2 = (Feature)polys[j];
                Geometry gt2 = tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Point)) continue;
                Point pt = (Point)gt2;
                if (ls.getBoundary().contains((Geometry)pt)) continue;
                r = true;
            }
            if (r) continue;
            results.error(tmp, "Polygon does not contained one of the specified points.");
            return false;
        }
        return true;
    }
}

