/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonPolygonAbstractValidation;

public class PolygonBoundaryCoveredByPolygonValidation
extends PolygonPolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource polySource = (FeatureSource)layers.get(this.getPolygonTypeRef());
        FeatureSource polyrSource = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        Object[] polys = polyrSource.getFeatures().collection().toArray();
        Object[] polyRs = polySource.getFeatures().collection().toArray();
        if (!envelope.contains(polySource.getBounds())) {
            results.error((Feature)polys[0], "Poly Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains(polyrSource.getBounds())) {
            results.error((Feature)polyRs[0], "Poly Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < polys.length; ++i) {
            Feature tmp = (Feature)polys[i];
            Geometry gt = tmp.getDefaultGeometry();
            if (!(gt instanceof Polygon)) continue;
            Polygon ls = (Polygon)gt;
            boolean r = false;
            for (int j = 0; j < polyRs.length && !r; ++j) {
                Polygon pt;
                Feature tmp2 = (Feature)polyRs[j];
                Geometry gt2 = tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Polygon) || (pt = (Polygon)gt2).getBoundary().within((Geometry)ls)) continue;
                r = true;
            }
            if (r) continue;
            results.error(tmp, "Polygon does not contained one of the specified polygons.");
            return false;
        }
        return true;
    }
}

