/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonLineAbstractValidation;

public class PolygonNotOverlappingLineValidation
extends PolygonLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        FeatureSource polySource1 = (FeatureSource)layers.get(this.getPolygonTypeRef());
        FeatureSource polySource2 = (FeatureSource)layers.get(this.getRestrictedLineTypeRef());
        Object[] poly1 = polySource1.getFeatures().collection().toArray();
        Object[] poly2 = polySource2.getFeatures().collection().toArray();
        if (!envelope.contains(polySource1.getBounds())) {
            results.error((Feature)poly1[0], "Polygon Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains(polySource2.getBounds())) {
            results.error((Feature)poly1[0], "Restricted Polygon Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < poly1.length; ++i) {
            Feature tmp = (Feature)poly1[i];
            Geometry gt = tmp.getDefaultGeometry();
            for (int j = 0; j < poly2.length; ++j) {
                Feature tmp2 = (Feature)poly2[j];
                Geometry gt2 = tmp2.getDefaultGeometry();
                if (!gt2.touches(gt)) continue;
                return false;
            }
        }
        return true;
    }
}

