/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonPolygonAbstractValidation;

public class PolygonNotOverlappingPolygonValidation
extends PolygonPolygonAbstractValidation {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.validation");
    boolean expected = true;

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getPolygonTypeRef();
        LOGGER.finer(typeRef1 + ": looking up FeatureSource ");
        FeatureSource polySource1 = (FeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + polySource1.getSchema().getTypeName());
        FeatureCollection features1 = polySource1.getFeatures();
        FeatureCollection collection1 = features1.collection();
        Object[] poly1 = collection1.toArray();
        String typeRef2 = this.getRestrictedPolygonTypeRef();
        LOGGER.finer(typeRef2 + ": looking up FeatureSource ");
        FeatureSource polySource2 = (FeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + polySource2.getSchema().getTypeName());
        FeatureCollection features2 = polySource2.getFeatures();
        FeatureCollection collection2 = features2.collection();
        Object[] poly2 = collection2.toArray();
        boolean success = true;
        for (int i = 0; i < poly1.length; ++i) {
            Feature tmp = (Feature)poly1[i];
            LOGGER.finest("Polgon overlap test for:" + tmp.getID());
            Geometry gt = tmp.getDefaultGeometry();
            for (int j = 0; j < poly2.length; ++j) {
                Feature tmp2 = (Feature)poly2[j];
                LOGGER.finest("Polgon overlap test against:" + tmp2.getID());
                Geometry gt2 = tmp2.getDefaultGeometry();
                if (gt2.overlaps(gt) == this.expected) continue;
                results.error(tmp, "Polygon " + typeRef1 + " overlapped Polygon " + typeRef2 + "(" + tmp2.getID() + ") was not " + this.expected);
                success = false;
            }
        }
        return success;
    }
}

