/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

class WriterUtils {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");
    protected Writer writer;

    protected WriterUtils() {
    }

    public WriterUtils(Writer writer) {
        this.writer = writer;
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
        this.writer.flush();
    }

    public void writeln(String s) throws IOException {
        this.writer.write(s + "\n");
        this.writer.flush();
    }

    public void openTag(String tagName) throws IOException {
        this.writeln("<" + tagName + ">");
    }

    public void openTag(String tagName, Map attributes) throws IOException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            this.write(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.writeln(">");
    }

    public void closeTag(String tagName) throws IOException {
        this.writeln("</" + tagName + ">");
    }

    public void textTag(String tagName, String data) throws IOException {
        this.writeln("<" + tagName + ">" + data + "</" + tagName + ">");
    }

    public void valueTag(String tagName, String value) throws IOException {
        this.writeln("<" + tagName + " value = \"" + value + "\" />");
    }

    public void attrTag(String tagName, Map attributes) throws IOException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            this.write(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.write(" />");
    }

    public void textTag(String tagName, Map attributes, String data) throws IOException {
        this.write("<" + tagName + " ");
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            this.write(s + " = " + "\"" + attributes.get(s).toString() + "\" ");
        }
        this.write(">" + data + "</" + tagName + ">");
    }

    public void comment(String comment) throws IOException {
        this.writeln("<!--");
        this.writeln(comment);
        this.writeln("-->");
    }
}

