/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.catalog.AbstractGeoResource;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.Service;
import org.geotools.catalog.defaults.DefaultGeoResourceInfo;
import org.geotools.catalog.shapefile.ShapefileService;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.ProgressListener;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileGeoResource
extends AbstractGeoResource {
    private ShapefileService parent;
    private String typeName;
    private Throwable msg;
    private GeoResourceInfo info;
    private FeatureSource featureSource;

    ShapefileGeoResource(ShapefileService parent, String typeName) {
        this.parent = parent;
        this.typeName = typeName;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(Service.class) || adaptee.isAssignableFrom(GeoResourceInfo.class) || adaptee.isAssignableFrom(FeatureStore.class) || adaptee.isAssignableFrom(FeatureSource.class);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        FeatureSource featureSource;
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Service.class)) {
            return this.parent;
        }
        if (adaptee.isAssignableFrom(GeoResource.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(FeatureStore.class) && (featureSource = this.getFeatureSource(monitor)) instanceof FeatureStore) {
            return featureSource;
        }
        if (adaptee.isAssignableFrom(FeatureSource.class)) {
            return this.getFeatureSource(monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoResourceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            ShapefileDataStore shapefileDataStore = this.parent.getDataStore(monitor);
            synchronized (shapefileDataStore) {
                if (this.info == null) {
                    ReferencedEnvelope bounds;
                    String[] keywords;
                    String description;
                    String title;
                    String name;
                    URI schema;
                    CoordinateReferenceSystem crs;
                    block12: {
                        FeatureType type = this.getFeatureSource(monitor).getSchema();
                        crs = type.getDefaultGeometry().getCoordinateSystem();
                        schema = type.getNamespace();
                        title = name = type.getTypeName();
                        description = name;
                        keywords = new String[]{".shp", "Shapefile", name, schema.toString()};
                        bounds = null;
                        try {
                            Envelope tmpBounds = this.getFeatureSource(monitor).getBounds();
                            bounds = tmpBounds instanceof ReferencedEnvelope ? (ReferencedEnvelope)tmpBounds : new ReferencedEnvelope(tmpBounds, crs);
                            if (bounds != null) break block12;
                            bounds = new ReferencedEnvelope(new Envelope(), crs);
                            FeatureIterator reader = this.getFeatureSource(monitor).getFeatures().features();
                            try {
                                while (reader.hasNext()) {
                                    Feature element = reader.next();
                                    if (bounds.isNull()) {
                                        bounds.init(element.getBounds());
                                        continue;
                                    }
                                    bounds.expandToInclude(element.getBounds());
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        catch (Exception e) {
                            bounds = new ReferencedEnvelope(new Envelope(), crs);
                        }
                    }
                    this.info = new DefaultGeoResourceInfo(title, name, description, schema, (Envelope)bounds, crs, keywords, null);
                }
            }
        }
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureSource getFeatureSource(ProgressListener monitor) throws IOException {
        if (this.featureSource == null) {
            ShapefileDataStore shapefileDataStore = this.parent.getDataStore(monitor);
            synchronized (shapefileDataStore) {
                if (this.featureSource == null) {
                    try {
                        this.msg = null;
                        ShapefileDataStore dataStore = this.parent.getDataStore(monitor);
                        if (dataStore != null) {
                            this.featureSource = dataStore.getFeatureSource(this.typeName);
                        }
                    }
                    catch (IOException ioe) {
                        this.msg = ioe;
                        throw ioe;
                    }
                    catch (Throwable t) {
                        this.msg = t;
                        throw (IOException)new IOException().initCause(t);
                    }
                }
            }
        }
        return this.featureSource;
    }

    public Resolve.Status getStatus() {
        if (this.msg == null) {
            if (this.featureSource != null) {
                return Resolve.Status.CONNECTED;
            }
            return Resolve.Status.NOTCONNECTED;
        }
        return Resolve.Status.BROKEN;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URI getIdentifier() {
        URI uri = this.parent.getIdentifier();
        if (uri != null) {
            try {
                return new URI(uri.toString() + "#" + this.typeName);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

