/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.shapefile;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.AbstractService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.shapefile.ShapefileGeoResource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.util.ProgressListener;

public class ShapefileService
extends AbstractService {
    private ServiceInfo info;
    private ShapefileDataStore dataStore;
    private Throwable msg;
    private URI uri;
    private Map params;
    private List members;

    public ShapefileService(Catalog parent, URI uri, Map params) {
        super(parent);
        this.params = params;
        this.uri = uri;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ServiceInfo.class) || adaptee.isAssignableFrom(List.class) || adaptee.isAssignableFrom(ShapefileDataStore.class);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(ServiceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return this.members(monitor);
        }
        if (adaptee.isAssignableFrom(ShapefileDataStore.class)) {
            return this.getDataStore(monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            ShapefileDataStore shapefileDataStore = this.getDataStore(monitor);
            synchronized (shapefileDataStore) {
                if (this.info == null) {
                    String title = this.getIdentifier().getPath();
                    String description = this.getIdentifier().toString();
                    String[] keywords = new String[]{".shp", "Shapefile", this.getDataStore(monitor).getTypeNames()[0]};
                    this.info = new DefaultServiceInfo(title, description, null, null, null, null, keywords, null);
                }
            }
        }
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShapefileDataStore getDataStore(ProgressListener monitor) throws IOException {
        if (this.dataStore == null) {
            Class clazz = ShapefileDataStore.class;
            synchronized (clazz) {
                ShapefileDataStoreFactory factory;
                if (this.dataStore == null && (factory = new ShapefileDataStoreFactory()).canProcess(this.params)) {
                    try {
                        this.msg = null;
                        this.dataStore = (ShapefileDataStore)factory.createDataStore(this.params);
                    }
                    catch (Throwable t) {
                        this.msg = t;
                        new IOException().initCause(t);
                    }
                }
            }
        }
        return this.dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List members(ProgressListener monitor) throws IOException {
        if (this.members == null) {
            ShapefileDataStore shapefileDataStore = this.getDataStore(monitor);
            synchronized (shapefileDataStore) {
                if (this.members == null) {
                    this.members = new LinkedList();
                    String[] typenames = this.getDataStore(monitor).getTypeNames();
                    if (typenames != null) {
                        for (int i = 0; i < typenames.length; ++i) {
                            this.members.add(new ShapefileGeoResource(this, typenames[i]));
                        }
                    }
                }
            }
        }
        return this.members;
    }

    public Map getConnectionParams() {
        return this.params;
    }

    public Resolve.Status getStatus() {
        if (this.msg == null) {
            if (this.dataStore != null) {
                return Resolve.Status.CONNECTED;
            }
            return Resolve.Status.NOTCONNECTED;
        }
        return Resolve.Status.BROKEN;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URI getIdentifier() {
        return this.uri;
    }
}

