/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultFIDReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.Lock;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.geotools.data.shapefile.shp.xml.ShpXmlFileReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.LengthFunction;
import org.geotools.filter.LiteralExpression;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.xml.gml.GMLSchema;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ShapefileDataStore
extends AbstractFileDataStore {
    public static final Charset DEFAULT_STRING_CHARSET = Charset.forName("ISO-8859-1");
    protected final URL shpURL;
    protected final URL dbfURL;
    protected final URL shxURL;
    protected final URL prjURL;
    protected final URL xmlURL;
    protected Lock readWriteLock = new Lock();
    protected URI namespace = null;
    protected FeatureType schema;
    protected boolean useMemoryMappedBuffer = true;
    protected Charset dbfCharset;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public ShapefileDataStore(URL url) throws MalformedURLException {
        this(url, true);
    }

    public ShapefileDataStore(URL url, boolean useMemoryMappedBuffer) throws MalformedURLException {
        this(url, useMemoryMappedBuffer, DEFAULT_STRING_CHARSET);
    }

    public ShapefileDataStore(URL url, boolean useMemoryMappedBuffer, Charset dbfCharset) throws MalformedURLException {
        String filename = null;
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.toExternalForm(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        String shpext = ".shp";
        String dbfext = ".dbf";
        String shxext = ".shx";
        String prjext = ".prj";
        String xmlext = ".shp.xml";
        if (filename.endsWith(shpext) || filename.endsWith(dbfext) || filename.endsWith(shxext)) {
            filename = filename.substring(0, filename.length() - 4);
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            shpext = ".SHP";
            dbfext = ".DBF";
            shxext = ".SHX";
            prjext = ".PRJ";
            xmlext = ".SHP.XML";
        }
        this.shpURL = new URL(filename + shpext);
        this.dbfURL = new URL(filename + dbfext);
        this.shxURL = new URL(filename + shxext);
        this.prjURL = new URL(filename + prjext);
        this.xmlURL = new URL(filename + xmlext);
        this.dbfCharset = dbfCharset;
    }

    public ShapefileDataStore(URL url, URI namespace) throws MalformedURLException {
        this(url);
        this.namespace = namespace;
    }

    public ShapefileDataStore(URL url, URI namespace, boolean useMemoryMapped, Charset dbfCharset) throws MalformedURLException {
        this(url);
        this.namespace = namespace;
        this.useMemoryMappedBuffer = useMemoryMapped;
        this.dbfCharset = dbfCharset;
    }

    public ShapefileDataStore(URL url, URI namespace, boolean useMemoryMapped) throws MalformedURLException {
        this(url);
        this.namespace = namespace;
        this.useMemoryMappedBuffer = useMemoryMapped;
    }

    public void setStringCharset(Charset stringCharset) {
        this.dbfCharset = stringCharset;
    }

    public Charset getStringCharset() {
        return this.dbfCharset;
    }

    protected Map createMetadata(String typeName) {
        if (this.xmlURL == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            System.out.println("found metadata = " + this.xmlURL);
            ShpXmlFileReader reader = new ShpXmlFileReader(this.xmlURL);
            HashMap<String, Metadata> map = new HashMap<String, Metadata>();
            map.put("shp.xml", reader.parse());
            System.out.println("parsed ..." + this.xmlURL);
            return map;
        }
        catch (Throwable t) {
            LOGGER.warning("Could not parse " + this.xmlURL + ":" + t.getLocalizedMessage());
            return Collections.EMPTY_MAP;
        }
    }

    public boolean isLocal() {
        return this.shpURL.getProtocol().equals("file");
    }

    private void clear() {
        if (this.isLocal()) {
            this.delete(this.shpURL);
            this.delete(this.dbfURL);
            this.delete(this.shxURL);
            this.delete(this.prjURL);
            this.delete(this.xmlURL);
        }
    }

    private void delete(URL u) {
        File f = DataUtilities.urlToFile((URL)u);
        f.delete();
    }

    protected ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file")) {
            File file = null;
            file = DataUtilities.urlToFile((URL)url);
            if (!file.exists()) {
                throw new FileNotFoundException(file.toString());
            }
            if (!file.canRead()) {
                throw new IOException("File is unreadable : " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    protected WritableByteChannel getWriteChannel(URL url) throws IOException {
        WritableByteChannel channel;
        if (url.getProtocol().equals("file")) {
            File file = DataUtilities.urlToFile((URL)url);
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            channel = raf.getChannel();
            ((FileChannel)channel).lock();
        } else {
            OutputStream out = url.openConnection().getOutputStream();
            channel = Channels.newChannel(out);
        }
        return channel;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getFeatureReader();
    }

    protected FeatureReader getFeatureReader() throws IOException {
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true), this.schema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", (Throwable)se);
        }
    }

    protected FeatureReader getFeatureReader(String typeName, Query query) throws IOException {
        String[] propertyNames = query.getPropertyNames();
        String defaultGeomName = this.schema.getDefaultGeometry().getName();
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        query.getFilter().accept((FilterVisitor)extractor);
        String[] filterAttnames = extractor.getAttributeNames();
        if (propertyNames != null && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName) && (filterAttnames.length == 0 || filterAttnames.length == 1 && filterAttnames[0].equals(defaultGeomName))) {
            try {
                FeatureType newSchema = DataUtilities.createSubType((FeatureType)this.schema, (String[])propertyNames);
                return this.createFeatureReader(typeName, this.getAttributesReader(false), newSchema);
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating schema", (Throwable)se);
            }
        }
        return super.getFeatureReader(typeName, query);
    }

    protected FeatureReader createFeatureReader(String typeName, Reader r, FeatureType readerSchema) throws SchemaException {
        return new FIDFeatureReader((AttributeReader)r, (FIDReader)new DefaultFIDReader(typeName), readerSchema);
    }

    protected Reader getAttributesReader(boolean readDbf) throws IOException {
        AttributeType[] atts;
        AttributeType[] attributeTypeArray = atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeTypes();
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new AttributeType[]{this.schema.getDefaultGeometry()};
            return new Reader(atts, this.openShapeReader(), null);
        }
        return new Reader(atts, this.openShapeReader(), this.openDbfReader());
    }

    protected ShapefileReader openShapeReader() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.shpURL);
        if (rbc == null) {
            return null;
        }
        try {
            return new ShapefileReader(rbc, true, this.useMemoryMappedBuffer, this.readWriteLock);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", (Throwable)((Object)se));
        }
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.dbfURL);
        if (rbc == null) {
            return null;
        }
        return new DbaseFileReader(rbc, this.useMemoryMappedBuffer, this.dbfCharset);
    }

    protected IndexFile openIndexFile(URL shxURL) throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(shxURL);
        if (rbc == null) {
            return null;
        }
        return new IndexFile(rbc, false);
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        ReadableByteChannel rbc = null;
        try {
            rbc = this.getReadChannel(this.prjURL);
        }
        catch (IOException e) {
            LOGGER.warning("projection (.prj) for shapefile: " + this.shpURL.toString() + " is not available");
        }
        if (rbc == null) {
            return null;
        }
        PrjFileReader prj = null;
        try {
            prj = new PrjFileReader(rbc);
        }
        catch (Exception e) {
            rbc.close();
        }
        return prj;
    }

    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        int slash;
        String path = this.shpURL.getPath();
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String requested) throws IOException {
        if (!this.getCurrentTypeName().equals(requested)) {
            throw new IOException("No such type : " + requested);
        }
    }

    protected FeatureWriter createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        this.typeCheck(typeName);
        return new Writer(typeName);
    }

    public FeatureType getSchema(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getSchema();
    }

    public FeatureType getSchema() throws IOException {
        if (this.schema == null) {
            try {
                AttributeType[] types = this.readAttributes();
                FeatureType parent = null;
                Class geomType = types[0].getType();
                if (geomType == Point.class || geomType == MultiPoint.class) {
                    parent = BasicFeatureTypes.POINT;
                } else if (geomType == Polygon.class || geomType == MultiPolygon.class) {
                    parent = BasicFeatureTypes.POLYGON;
                } else if (geomType == LineString.class || geomType == MultiLineString.class) {
                    parent = BasicFeatureTypes.LINE;
                }
                this.schema = parent != null ? FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)this.namespace, (boolean)false, (FeatureType[])new FeatureType[]{parent}) : (this.namespace != null ? FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)this.namespace, (boolean)false) : FeatureTypes.newFeatureType((AttributeType[])this.readAttributes(), (String)this.createFeatureTypeName(), (URI)GMLSchema.NAMESPACE, (boolean)false));
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating FeatureType", (Throwable)se);
            }
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributeType[] readAttributes() throws IOException {
        ShapefileReader shp = this.openShapeReader();
        DbaseFileReader dbf = this.openDbfReader();
        AbstractCRS cs = null;
        PrjFileReader prj = null;
        try {
            prj = this.openPrjReader();
            if (prj != null) {
                cs = (AbstractCRS)prj.getCoodinateSystem();
            }
        }
        catch (FactoryException fe) {
            cs = null;
        }
        finally {
            if (prj != null) {
                prj.close();
            }
        }
        try {
            AttributeType[] atts;
            GeometryAttributeType geometryAttribute = (GeometryAttributeType)AttributeTypeFactory.newAttributeType((String)"the_geom", (Class)JTSUtilities.findBestGeometryClass(shp.getHeader().getShapeType()), (boolean)true, (int)0, null, (Object)cs);
            if (dbf != null) {
                DbaseFileHeader header = dbf.getHeader();
                atts = new AttributeType[header.getNumFields() + 1];
                atts[0] = geometryAttribute;
                int ii = header.getNumFields();
                for (int i = 0; i < ii; ++i) {
                    Class clazz = header.getFieldClass(i);
                    atts[i + 1] = AttributeTypeFactory.newAttributeType((String)header.getFieldName(i), (Class)clazz, (boolean)true, (int)header.getFieldLength(i));
                }
            } else {
                atts = new AttributeType[]{geometryAttribute};
            }
            AttributeType[] attributeTypeArray = atts;
            return attributeTypeArray;
        }
        finally {
            try {
                shp.close();
            }
            catch (IOException ioe) {}
            try {
                dbf.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSchemaCRS(CoordinateReferenceSystem crs) throws IOException {
        if (crs == null) {
            throw new NullPointerException("CRS required for .prj file");
        }
        long temp = System.currentTimeMillis();
        String s = crs.toWKT();
        FileWriter out = new FileWriter(this.getStorageFile(this.prjURL, temp));
        try {
            out.write(s);
        }
        finally {
            out.close();
        }
        this.copyAndDelete(this.prjURL, temp);
        this.schema = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(FeatureType featureType) throws IOException {
        if (!this.isLocal()) {
            throw new IOException("Cannot create FeatureType on remote shapefile");
        }
        this.clear();
        this.schema = featureType;
        CoordinateReferenceSystem cs = featureType.getDefaultGeometry().getCoordinateSystem();
        long temp = System.currentTimeMillis();
        if (this.isLocal()) {
            ShapeType shapeType;
            Class geomType;
            if (Point.class.isAssignableFrom(geomType = featureType.getDefaultGeometry().getType())) {
                shapeType = ShapeType.POINT;
            } else if (MultiPoint.class.isAssignableFrom(geomType)) {
                shapeType = ShapeType.MULTIPOINT;
            } else if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
                shapeType = ShapeType.ARC;
            } else if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
                shapeType = ShapeType.POLYGON;
            } else {
                return;
            }
            FileChannel shpChannel = (FileChannel)this.getWriteChannel(this.getStorageURL(this.shpURL, temp));
            FileChannel shxChannel = (FileChannel)this.getWriteChannel(this.getStorageURL(this.shxURL, temp));
            ShapefileWriter writer = null;
            try {
                Envelope transformedBounds;
                writer = new ShapefileWriter(shpChannel, shxChannel, this.readWriteLock);
                Envelope env = new Envelope(-179.0, 179.0, -89.0, 89.0);
                if (cs != null) {
                    try {
                        transformedBounds = JTS.transform((Envelope)env, (MathTransform)CRS.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)cs, (boolean)true));
                    }
                    catch (Exception e) {
                        cs = null;
                        transformedBounds = env;
                    }
                } else {
                    transformedBounds = env;
                }
                writer.writeHeaders(transformedBounds, shapeType, 0, 100);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            DbaseFileHeader dbfheader = ShapefileDataStore.createDbaseHeader(featureType);
            dbfheader.setNumRecords(0);
            WritableByteChannel writeChannel = this.getWriteChannel(this.getStorageURL(this.dbfURL, temp));
            try {
                dbfheader.writeHeader(writeChannel);
            }
            finally {
                writeChannel.close();
            }
        }
        if (cs != null) {
            String s = cs.toWKT();
            FileWriter out = new FileWriter(this.getStorageFile(this.prjURL, temp));
            try {
                out.write(s);
            }
            finally {
                out.close();
            }
        }
        this.copyAndDelete(this.shpURL, temp);
        this.copyAndDelete(this.shxURL, temp);
        this.copyAndDelete(this.dbfURL, temp);
        if (!this.prjURL.equals("")) {
            try {
                this.copyAndDelete(this.prjURL, temp);
            }
            catch (FileNotFoundException e) {
                LOGGER.warning(".prj could not be created.");
            }
        }
    }

    /*
     * Loose catch block
     */
    protected Envelope getBounds() throws DataSourceException {
        Envelope env;
        ReadableByteChannel in;
        block12: {
            in = null;
            ByteBuffer buffer = ByteBuffer.allocate(100);
            in = this.getReadChannel(this.shpURL);
            in.read(buffer);
            buffer.flip();
            ShapefileHeader header = new ShapefileHeader();
            header.read(buffer, true);
            env = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
            if (this.schema == null) break block12;
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, this.schema.getDefaultGeometry().getCoordinateSystem());
            Object var7_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return referencedEnvelope;
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, null);
        Object var7_9 = null;
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe2) {
            // empty catch block
        }
        return referencedEnvelope;
        catch (IOException ioe) {
            try {
                throw new DataSourceException("Problem getting Bbox", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe2) {}
                throw throwable;
            }
        }
    }

    protected Envelope getBounds(Query query) throws IOException {
        if (query.getFilter().equals(Filter.NONE)) {
            return this.getBounds();
        }
        return null;
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        final FeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new AbstractFeatureLocking(){

                    public DataStore getDataStore() {
                        return ShapefileDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        ShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        ShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                    }

                    public FeatureType getSchema() {
                        return featureType;
                    }

                    public Envelope getBounds(Query query) throws IOException {
                        return ShapefileDataStore.this.getBounds(query);
                    }
                };
            }
            return new AbstractFeatureStore(){

                public DataStore getDataStore() {
                    return ShapefileDataStore.this;
                }

                public void addFeatureListener(FeatureListener listener) {
                    ShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                }

                public void removeFeatureListener(FeatureListener listener) {
                    ShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                }

                public FeatureType getSchema() {
                    return featureType;
                }

                public Envelope getBounds(Query query) throws IOException {
                    return ShapefileDataStore.this.getBounds(query);
                }
            };
        }
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ShapefileDataStore.this;
            }

            public void addFeatureListener(FeatureListener listener) {
                ShapefileDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ShapefileDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }

            public Envelope getBounds(Query query) throws IOException {
                return ShapefileDataStore.this.getBounds(query);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCount(Query query) throws IOException {
        if (query.getFilter() != Filter.NONE) return super.getCount(query);
        try {
            IndexFile file = this.openIndexFile(this.shxURL);
            try {
                int n = file.getRecordCount();
                return n;
            }
            finally {
                file.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            ShapefileReader reader = new ShapefileReader(this.getReadChannel(this.shpURL), this.readWriteLock);
            int count = -1;
            try {
                count = reader.getCount(count);
                Object var7_8 = null;
            }
            catch (Throwable throwable2) {
                Object var7_9 = null;
                try {
                    if (reader == null) throw throwable2;
                    reader.close();
                    throw throwable2;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable2;
            }
            try {}
            catch (IOException ioe) {}
            if (reader == null) return count;
            reader.close();
            return count;
        }
    }

    protected static DbaseFileHeader createDbaseHeader(FeatureType featureType) throws IOException, DbaseFileException {
        DbaseFileHeader header = new DbaseFileHeader();
        int ii = featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            AttributeType type = featureType.getAttributeType(i);
            Class colType = type.getType();
            String colName = type.getName();
            int fieldLen = -1;
            Filter f = type.getRestriction();
            if (f != null && f != Filter.ALL && f != Filter.NONE && (f.getFilterType() == 15 || f.getFilterType() == 17)) {
                try {
                    CompareFilter cf = (CompareFilter)f;
                    if (cf.getLeftValue() instanceof LengthFunction) {
                        fieldLen = Integer.parseInt(((LiteralExpression)cf.getRightValue()).getLiteral().toString());
                    } else if (cf.getRightValue() instanceof LengthFunction) {
                        fieldLen = Integer.parseInt(((LiteralExpression)cf.getLeftValue()).getLiteral().toString());
                    }
                }
                catch (NumberFormatException e) {
                    fieldLen = 256;
                }
            } else {
                fieldLen = 256;
            }
            if (fieldLen <= 0) {
                fieldLen = 255;
            }
            if (colType == (class$java$lang$Integer == null ? ShapefileDataStore.class$("java.lang.Integer") : class$java$lang$Integer) || colType == (class$java$lang$Short == null ? ShapefileDataStore.class$("java.lang.Short") : class$java$lang$Short) || colType == (class$java$lang$Byte == null ? ShapefileDataStore.class$("java.lang.Byte") : class$java$lang$Byte)) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 9), 0);
                continue;
            }
            if (colType == (class$java$lang$Long == null ? ShapefileDataStore.class$("java.lang.Long") : class$java$lang$Long)) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 19), 0);
                continue;
            }
            if (colType == (class$java$math$BigInteger == null ? ShapefileDataStore.class$("java.math.BigInteger") : class$java$math$BigInteger)) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 33), 0);
                continue;
            }
            if ((class$java$lang$Number == null ? ShapefileDataStore.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(colType)) {
                int l = Math.min(fieldLen, 33);
                int d = Math.max(l - 2, 0);
                header.addColumn(colName, 'N', l, d);
                continue;
            }
            if ((class$java$util$Date == null ? ShapefileDataStore.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(colType)) {
                header.addColumn(colName, 'D', fieldLen, 0);
                continue;
            }
            if (colType == (class$java$lang$Boolean == null ? ShapefileDataStore.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                header.addColumn(colName, 'L', 1, 0);
                continue;
            }
            if ((class$java$lang$CharSequence == null ? ShapefileDataStore.class$("java.lang.CharSequence") : class$java$lang$CharSequence).isAssignableFrom(colType)) {
                header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
                continue;
            }
            if ((class$com$vividsolutions$jts$geom$Geometry == null ? ShapefileDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(colType)) continue;
            throw new IOException("Unable to write : " + colType.getName());
        }
        return header;
    }

    protected URL getStorageURL(URL url, long temp) throws MalformedURLException {
        return temp == 0L ? url : this.getStorageFile(url, temp).toURL();
    }

    protected File getStorageFile(URL url, long temp) {
        String f = url.getFile();
        f = temp + f.substring(f.lastIndexOf("/") + 1);
        File tf = new File(System.getProperty("java.io.tmpdir"), f);
        return tf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAndDelete(URL src, long temp) throws IOException {
        AbstractInterruptibleChannel out;
        File storage;
        block9: {
            storage = this.getStorageFile(src, temp);
            File dest = DataUtilities.urlToFile((URL)src);
            AbstractInterruptibleChannel in = null;
            out = null;
            if (storage.equals(dest)) {
                return;
            }
            try {
                this.readWriteLock.lockWrite();
                if (dest.exists() && !dest.delete()) {
                    throw new IOException("Unable to delete original file: " + src);
                }
                if (storage.exists() && !storage.renameTo(dest)) {
                    long copied;
                    in = new FileInputStream(storage).getChannel();
                    out = new FileOutputStream(dest).getChannel();
                    long len = ((FileChannel)in).size();
                    if (len != (copied = ((FileChannel)out).transferFrom((ReadableByteChannel)((Object)in), 0L, ((FileChannel)in).size()))) {
                        throw new IOException("unable to complete write: " + src);
                    }
                }
                Object var13_9 = null;
                this.readWriteLock.unlockWrite();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                Object var13_10 = null;
                this.readWriteLock.unlockWrite();
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                storage.delete();
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
        storage.delete();
    }

    protected class Writer
    implements FeatureWriter {
        private long temp;
        protected FeatureReader featureReader;
        protected Reader attReader;
        private Feature currentFeature;
        private FeatureType featureType;
        private Object[] emptyAtts;
        private Object[] transferCache;
        private ShapeType shapeType;
        private ShapeHandler handler;
        private int shapefileLength = 100;
        private int records = 0;
        private byte[] writeFlags;
        private ShapefileWriter shpWriter;
        private DbaseFileWriter dbfWriter;
        private DbaseFileHeader dbfHeader;
        private FileChannel dbfChannel;
        private Envelope bounds = new Envelope();

        public Writer(String typeName) throws IOException {
            try {
                this.attReader = ShapefileDataStore.this.getAttributesReader(true);
                this.featureReader = ShapefileDataStore.this.createFeatureReader(typeName, this.attReader, ShapefileDataStore.this.schema);
                this.temp = System.currentTimeMillis();
            }
            catch (Exception e) {
                ShapefileDataStore.this.getSchema();
                if (ShapefileDataStore.this.schema == null) {
                    throw new IOException("To create a shapefile, you must first call createSchema()");
                }
                this.featureReader = new EmptyFeatureReader(ShapefileDataStore.this.schema);
                this.temp = 0L;
            }
            this.featureType = this.featureReader.getFeatureType();
            this.emptyAtts = new Object[this.featureType.getAttributeCount()];
            this.writeFlags = new byte[this.featureType.getAttributeCount()];
            int cnt = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.featureType.getAttributeType(i) instanceof GeometryAttributeType) continue;
                ++cnt;
                this.writeFlags[i] = 1;
            }
            this.transferCache = new Object[cnt];
            this.shpWriter = new ShapefileWriter((FileChannel)ShapefileDataStore.this.getWriteChannel(ShapefileDataStore.this.getStorageURL(ShapefileDataStore.this.shpURL, this.temp)), (FileChannel)ShapefileDataStore.this.getWriteChannel(ShapefileDataStore.this.getStorageURL(ShapefileDataStore.this.shxURL, this.temp)), ShapefileDataStore.this.readWriteLock);
            this.dbfChannel = (FileChannel)ShapefileDataStore.this.getWriteChannel(ShapefileDataStore.this.getStorageURL(ShapefileDataStore.this.dbfURL, this.temp));
            this.dbfHeader = ShapefileDataStore.createDbaseHeader(this.featureType);
            this.dbfWriter = new DbaseFileWriter(this.dbfHeader, this.dbfChannel);
            if (this.attReader != null && this.attReader.hasNext()) {
                this.shapeType = this.attReader.shp.getHeader().getShapeType();
                this.handler = this.shapeType.getShapeHandler();
                this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            }
        }

        protected void flush() throws IOException {
            if (this.records <= 0 && this.shapeType == null) {
                GeometryAttributeType geometryAttributeType = this.featureType.getDefaultGeometry();
                Class gat = geometryAttributeType.getType();
                this.shapeType = JTSUtilities.getShapeType(gat);
            }
            this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            this.dbfHeader.setNumRecords(this.records);
            this.dbfChannel.position(0L);
            this.dbfHeader.writeHeader(this.dbfChannel);
        }

        protected void finalize() throws Throwable {
            if (this.featureReader != null) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void clean() throws IOException {
            if (this.temp == 0L) {
                return;
            }
            ShapefileDataStore.this.copyAndDelete(ShapefileDataStore.this.shpURL, this.temp);
            ShapefileDataStore.this.copyAndDelete(ShapefileDataStore.this.shxURL, this.temp);
            ShapefileDataStore.this.copyAndDelete(ShapefileDataStore.this.dbfURL, this.temp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object v1;
            block10: {
                if (this.featureReader == null) {
                    throw new IOException("Writer closed");
                }
                if (this.currentFeature != null) {
                    this.write();
                }
                if (this.attReader != null && this.attReader.hasNext()) {
                    this.shapeType = this.attReader.shp.getHeader().getShapeType();
                    this.handler = this.shapeType.getShapeHandler();
                    if (this.records == 0) {
                        this.shpWriter.writeHeaders(this.bounds, this.shapeType, 0, 0);
                    }
                    double[] env = new double[4];
                    while (this.attReader.hasNext()) {
                        this.shapefileLength += this.attReader.shp.transferTo(this.shpWriter, ++this.records, env);
                        this.bounds.expandToInclude(env[0], env[1]);
                        this.bounds.expandToInclude(env[2], env[3]);
                        this.attReader.dbf.transferTo(this.dbfWriter);
                    }
                }
                try {
                    this.featureReader.close();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var3_3 = null;
                    try {
                        this.flush();
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        v0 = null;
                    }
                    Object var5_7 = v0;
                    this.shpWriter.close();
                    this.dbfWriter.close();
                    this.dbfChannel.close();
                    throw throwable;
                }
                try {
                    this.flush();
                    v1 = null;
                    break block10;
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                {
                }
            }
            Object var5_6 = v1;
            this.shpWriter.close();
            this.dbfWriter.close();
            this.dbfChannel.close();
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }

        public boolean hasNext() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            return this.featureReader.hasNext();
        }

        public Feature next() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature != null) {
                this.write();
            }
            if (this.featureReader.hasNext()) {
                try {
                    this.currentFeature = this.featureReader.next();
                    return this.currentFeature;
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("Error in reading", (Throwable)iae);
                }
            }
            try {
                this.currentFeature = DataUtilities.template((FeatureType)this.getFeatureType(), (Object[])this.emptyAtts);
                return this.currentFeature;
            }
            catch (IllegalAttributeException iae) {
                throw new DataSourceException("Error creating empty Feature", (Throwable)iae);
            }
        }

        public void remove() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            this.currentFeature = null;
        }

        public void write() throws IOException {
            Envelope b;
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            Geometry g = this.currentFeature.getDefaultGeometry();
            if (this.shapeType == null) {
                int dims = JTSUtilities.guessCoorinateDims(g.getCoordinates());
                try {
                    this.shapeType = JTSUtilities.getShapeType(g, dims);
                    this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
                    this.handler = this.shapeType.getShapeHandler();
                }
                catch (ShapefileException se) {
                    throw new RuntimeException("Unexpected Error", (Throwable)((Object)se));
                }
            }
            if (!(b = (g = JTSUtilities.convertToCollection(g, this.shapeType)).getEnvelopeInternal()).isNull()) {
                this.bounds.expandToInclude(b);
            }
            this.shapefileLength += this.handler.getLength(g) + 8;
            this.shpWriter.writeGeometry(g);
            int idx = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.writeFlags[i] <= 0) continue;
                this.transferCache[idx++] = this.currentFeature.getAttribute(i);
            }
            this.dbfWriter.write(this.transferCache);
            ++this.records;
            this.currentFeature = null;
        }
    }

    protected static class Reader
    extends AbstractAttributeIO
    implements AttributeReader {
        protected ShapefileReader shp;
        protected DbaseFileReader dbf;
        protected DbaseFileReader.Row row;
        protected ShapefileReader.Record record;
        int cnt;

        public Reader(AttributeType[] atts, ShapefileReader shp, DbaseFileReader dbf) {
            super(atts);
            this.shp = shp;
            this.dbf = dbf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.shp != null) {
                    this.shp.close();
                }
                if (this.dbf != null) {
                    this.dbf.close();
                }
                Object var2_1 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
                throw throwable;
            }
        }

        public boolean hasNext() throws IOException {
            int n;
            int n2 = n = this.shp.hasNext() ? 1 : 0;
            if (this.dbf != null) {
                n += this.dbf.hasNext() ? 2 : 0;
            }
            if (n == 3 || n == 1 && this.dbf == null) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
        }

        public void next() throws IOException {
            this.record = this.shp.nextRecord();
            if (this.dbf != null) {
                this.row = this.dbf.readRow();
            }
        }

        public Object read(int param) throws IOException, ArrayIndexOutOfBoundsException {
            switch (param) {
                case 0: {
                    return this.record.shape();
                }
            }
            if (this.row != null) {
                return this.row.read(param - 1);
            }
            return null;
        }
    }
}

