/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStore;

public class ShapefileDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final DataStoreFactorySpi.Param URLP = new DataStoreFactorySpi.Param("url", URL.class, "url to a .shp file");
    public static final DataStoreFactorySpi.Param NAMESPACEP = new DataStoreFactorySpi.Param("namespace", URI.class, "uri to a the namespace", false);
    public static final DataStoreFactorySpi.Param MEMORY_MAPPED = new DataStoreFactorySpi.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false);
    static final DataStoreFactorySpi.Param DBFCHARSET = new DataStoreFactorySpi.Param("charset", Charset.class, "character used to decode strings from the DBF file", false, Charset.forName("ISO-8859-1")){

        public Object parse(String text) throws IOException {
            return Charset.forName(text);
        }

        public String text(Object value) {
            return ((Charset)value).name();
        }
    };
    private Map liveStores = new HashMap();

    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL url = (URL)URLP.lookUp(params);
                accept = this.canProcess(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return accept;
    }

    public DataStore createDataStore(Map params) throws IOException {
        DataStore ds = null;
        if (!this.liveStores.containsKey(params)) {
            Object url = null;
            try {
                ds = this.createNewDataStore(params);
                this.liveStores.put(params, ds);
            }
            catch (MalformedURLException mue) {
                throw new DataSourceException("Unable to attatch datastore to " + url, (Throwable)mue);
            }
        } else {
            ds = (DataStore)this.liveStores.get(params);
        }
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        ShapefileDataStore ds = null;
        URL url = null;
        try {
            url = (URL)URLP.lookUp(params);
            Boolean mm = (Boolean)MEMORY_MAPPED.lookUp(params);
            URI namespace = (URI)NAMESPACEP.lookUp(params);
            Charset dbfCharset = (Charset)DBFCHARSET.lookUp(params);
            if (dbfCharset == null) {
                dbfCharset = Charset.forName("ISO-8859-1");
            }
            if (mm == null) {
                mm = Boolean.FALSE;
            }
            ds = new ShapefileDataStore(url, namespace, mm, dbfCharset);
        }
        catch (MalformedURLException mue) {
            throw new DataSourceException("Unable to attatch datastore to " + url, (Throwable)mue);
        }
        return ds;
    }

    public String getDisplayName() {
        return "Shapefile";
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public boolean isAvailable() {
        return true;
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{URLP, DBFCHARSET};
    }

    public String[] getFileExtensions() {
        return new String[]{".shp"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toUpperCase().endsWith("SHP");
    }

    public DataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        return this.createDataStore(params);
    }

    public DataStore createDataStore(URL url, boolean memorymapped) throws IOException {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(ShapefileDataStoreFactory.URLP.key, url);
        params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, new Boolean(memorymapped));
        return this.createDataStore(params);
    }

    public String getTypeName(URL url) throws IOException {
        DataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        return names == null || names.length == 0 ? null : names[0];
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

