/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.resources.NIOUtilities;

public class IndexFile {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.shapefile");
    private static final int RECS_IN_BUFFER = 2000;
    private boolean useMemoryMappedBuffer;
    private FileChannel channel;
    private int channelOffset;
    private ByteBuffer buf = null;
    private int lastIndex = -1;
    private int recOffset;
    private int recLen;
    private ShapefileHeader header = null;
    private int[] content;
    private StreamLogging streamLogger = new StreamLogging("IndexFile");

    public IndexFile(ReadableByteChannel channel) throws IOException {
        this(channel, false);
    }

    public IndexFile(ReadableByteChannel channel, boolean useMemoryMappedBuffer) throws IOException {
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
        this.streamLogger.open();
        this.readHeader(channel);
        if (channel instanceof FileChannel) {
            this.channel = (FileChannel)channel;
            if (useMemoryMappedBuffer) {
                LOGGER.finest("Memory mapping file...");
                this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
                this.channelOffset = 0;
            } else {
                LOGGER.finest("Reading from file...");
                this.buf = ByteBuffer.allocateDirect(16000);
                this.channelOffset = 100;
            }
        } else {
            LOGGER.finest("Loading all shx...");
            this.readRecords(channel);
        }
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    private void readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
        buffer.flip();
        this.header = new ShapefileHeader();
        this.header.read(buffer, true);
        NIOUtilities.clean((ByteBuffer)buffer);
    }

    private void readRecords(ReadableByteChannel channel) throws IOException {
        int remaining = this.header.getFileLength() * 2 - 100;
        ByteBuffer buffer = ByteBuffer.allocateDirect(remaining);
        buffer.order(ByteOrder.BIG_ENDIAN);
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
        buffer.flip();
        int records = remaining / 4;
        this.content = new int[records];
        IntBuffer ints = buffer.asIntBuffer();
        ints.get(this.content);
        NIOUtilities.clean((ByteBuffer)buffer);
    }

    private void readRecord(int index) throws IOException {
        int pos = 100 + index * 8;
        if (!(this.useMemoryMappedBuffer || pos - this.channelOffset >= 0 && this.channelOffset + this.buf.limit() > pos && this.lastIndex != -1)) {
            LOGGER.finest("Filling buffer...");
            this.channelOffset = pos;
            this.channel.position(pos);
            this.buf.clear();
            this.channel.read(this.buf);
            this.buf.flip();
        }
        this.buf.position(pos - this.channelOffset);
        this.recOffset = this.buf.getInt();
        this.recLen = this.buf.getInt();
        this.lastIndex = index;
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
            if (this.buf instanceof MappedByteBuffer) {
                NIOUtilities.clean((ByteBuffer)this.buf);
            } else {
                this.buf.clear();
            }
        }
        this.buf = null;
        this.content = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int getRecordCount() {
        return (this.header.getFileLength() * 2 - 100) / 8;
    }

    public int getOffset(int index) throws IOException {
        int ret = -1;
        if (this.channel != null) {
            if (this.lastIndex != index) {
                this.readRecord(index);
            }
            ret = this.recOffset;
        } else {
            ret = this.content[2 * index];
        }
        return ret;
    }

    public int getOffsetInBytes(int index) throws IOException {
        return this.getOffset(index) * 2;
    }

    public int getContentLength(int index) throws IOException {
        int ret = -1;
        if (this.channel != null) {
            if (this.lastIndex != index) {
                this.readRecord(index);
            }
            ret = this.recLen;
        } else {
            ret = this.content[2 * index + 1];
        }
        return ret;
    }
}

