/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory = new GeometryFactory();
    RobustCGAlgorithms cga = new RobustCGAlgorithms();
    final ShapeType shapeType;

    public PolygonHandler() {
        this.shapeType = ShapeType.POLYGON;
    }

    public PolygonHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.POLYGON && type != ShapeType.POLYGONM && type != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = type;
    }

    boolean pointInList(Coordinate testPoint, Coordinate[] pointList) {
        for (int t = pointList.length - 1; t >= 0; --t) {
            Coordinate p = pointList[t];
            if (testPoint.x != p.x || testPoint.y != p.y || testPoint.z != p.z && testPoint.z == testPoint.z) continue;
            return true;
        }
        return false;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength(Object geometry) {
        void var5_6;
        int length;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.shapeType == ShapeType.POLYGONZ) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16 + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGONM) {
            length = 44 + 4 * nrings + 16 * npoints + 8 * npoints + 16;
        } else if (this.shapeType == ShapeType.POLYGON) {
            length = 44 + 4 * nrings + 16 * npoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Polygon, got " + this.shapeType);
        }
        return (int)var5_6;
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        Coordinate[] coords = this.readCoordinates(buffer, numPoints);
        if (this.shapeType == ShapeType.POLYGONZ) {
            buffer.position(buffer.position() + 16);
            for (int t = 0; t < numPoints; ++t) {
                coords[t].z = buffer.getDouble();
            }
        }
        int offset = 0;
        for (int part = 0; part < numParts; ++part) {
            int start = partOffsets[part];
            int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
            int length = finish - start;
            Coordinate[] points = new Coordinate[length];
            for (int i = 0; i < length; ++i) {
                points[i] = coords[offset++];
            }
            if (points.length != 0 && points.length <= 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(points);
            if (CGAlgorithms.isCCW((Coordinate[])points)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        if (shells.size() == 1) {
            return this.createMulti((LinearRing)shells.get(0), holes);
        }
        if (holes.size() == 1 && shells.size() == 0) {
            Logger.getLogger("org.geotools.data.shapefile").warning("only one hole in this polygon record");
            return this.createMulti(JTSUtilities.reverseRing((LinearRing)holes.get(0)));
        }
        ArrayList holesForShells = this.assignHolesToShells(shells, holes);
        Geometry g = this.buildGeometries(shells, holes, holesForShells);
        return g;
    }

    private Coordinate[] readCoordinates(ByteBuffer buffer, int numPoints) {
        Coordinate[] coords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            coords[t] = new Coordinate(buffer.getDouble(), buffer.getDouble());
        }
        return coords;
    }

    private Geometry buildGeometries(List shells, List holes, List holesForShells) {
        int i;
        Polygon[] polygons = shells.size() > 0 ? new Polygon[shells.size()] : new Polygon[holes.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = this.geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        if (shells.size() == 0) {
            int ii = holes.size();
            for (i = 0; i < ii; ++i) {
                LinearRing hole = (LinearRing)holes.get(i);
                polygons[i] = this.geometryFactory.createPolygon(JTSUtilities.reverseRing(hole), new LinearRing[0]);
            }
        }
        MultiPolygon g = this.geometryFactory.createMultiPolygon(polygons);
        return g;
    }

    ArrayList assignHolesToShells(ArrayList shells, ArrayList holes) {
        int i;
        ArrayList holesForShells = new ArrayList(shells.size());
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList) || this.pointInList(testPt, coordList))) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                Logger.getLogger("org.geotools.data.shapefile").warning("polygon found with a hole thats not inside a shell");
                shells.add(JTSUtilities.reverseRing(testRing));
                holesForShells.add(new ArrayList());
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        return holesForShells;
    }

    private MultiPolygon createMulti(LinearRing single) {
        return this.createMulti(single, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing single, List holes) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(single, holes.toArray(new LinearRing[holes.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        int t;
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : this.geometryFactory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
        Envelope box = multi.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        int nrings = 0;
        for (int t2 = 0; t2 < multi.getNumGeometries(); ++t2) {
            Polygon p = (Polygon)multi.getGeometryN(t2);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        for (int t3 = 0; t3 < multi.getNumGeometries(); ++t3) {
            Polygon p = (Polygon)multi.getGeometryN(t3);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            for (int v = 0; v < p.getNumInteriorRing(); ++v) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
            }
        }
        int npoints = multi.getNumPoints();
        buffer.putInt(nrings);
        buffer.putInt(npoints);
        int count = 0;
        for (int t4 = 0; t4 < nrings; ++t4) {
            buffer.putInt(count);
            count += pointsPerRing[t4];
        }
        Coordinate[] coords = multi.getCoordinates();
        for (t = 0; t < coords.length; ++t) {
            buffer.putDouble(coords[t].x);
            buffer.putDouble(coords[t].y);
        }
        if (this.shapeType == ShapeType.POLYGONZ) {
            double[] zExtreame = JTSUtilities.zMinMax(multi.getCoordinates());
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t5 = 0; t5 < npoints; ++t5) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.POLYGONM || this.shapeType == ShapeType.POLYGONZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

