/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.tiger.TigerGeometryAdapter;
import org.geotools.data.tiger.TigerSchemaElement;
import org.geotools.data.tiger.TigerSchemaManager;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;

public class TigerAttributeReader
implements AttributeReader {
    private BufferedReader rt1Reader;
    private BufferedReader rt2Reader;
    private FeatureType featureType;
    private String currentLine;
    private String nextLine;
    private TigerSchemaManager schemaManager = new TigerSchemaManager();
    private TigerGeometryAdapter geometryAdapter;
    private String typeName;
    private String namespace;
    private String typeKey;

    public TigerAttributeReader(File file, String namespace, String typeName) throws IOException {
        this.typeName = typeName;
        this.namespace = namespace;
        this.typeKey = this.schemaManager.getTypeKey(typeName);
        String fileName1 = file.getPath();
        String fileName = fileName1.substring(0, fileName1.lastIndexOf("1")) + "2";
        this.rt1Reader = new BufferedReader(new FileReader(file));
        this.rt2Reader = new BufferedReader(new FileReader(new File(fileName)));
        this.geometryAdapter = new TigerGeometryAdapter(this.rt2Reader);
        String typeSpec = this.schemaManager.getTypeSpec(typeName);
        try {
            this.featureType = DataUtilities.createType((String)this.typeName, (String)typeSpec);
        }
        catch (SchemaException e) {
            throw new DataSourceException(this.typeName + " schema not available", (Throwable)e);
        }
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    private static String getTypeName(File file) {
        String name = file.getName();
        int split = name.lastIndexOf(46);
        return split == -1 ? name : name.substring(split);
    }

    private static String getNamespace(File file) {
        String name = file.getName();
        int split = name.lastIndexOf(46);
        return split == -1 ? name : name.substring(split);
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public AttributeType getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.featureType.getAttributeType(index);
    }

    public void close() throws IOException {
        this.rt1Reader.close();
        this.rt1Reader = null;
        this.rt2Reader.close();
        this.rt2Reader = null;
    }

    public boolean hasNext() throws IOException {
        if (this.nextLine != null) {
            return true;
        }
        do {
            this.nextLine = this.rt1Reader.readLine();
        } while (this.nextLine != null && !this.isKeyTypeRecord());
        return this.nextLine != null;
    }

    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentLine = this.nextLine;
        this.nextLine = null;
    }

    private boolean isKeyTypeRecord() {
        if (this.nextLine == null) {
            return false;
        }
        return this.nextLine.substring(55, 56).equals(this.typeKey);
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.currentLine == null) {
            throw new IOException("No data available.");
        }
        TigerSchemaElement[] elements = this.schemaManager.getSchema(this.typeName);
        if (index < 0 || index >= elements.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elements[index].getClassType() == "Geometry") {
            Geometry geom = this.geometryAdapter.deSerialize(this.getFeatureID(), this.currentLine);
            return this.featureType.getAttributeType(index).parse((Object)geom);
        }
        String elemData = this.currentLine.substring(elements[index].getStartPos(), elements[index].getEndPos()).trim();
        if (elemData.length() == 0) {
            return this.featureType.getAttributeType(index).parse(null);
        }
        if (elements[index].getClassType() == "String") {
            return this.featureType.getAttributeType(index).parse((Object)elemData);
        }
        if (elements[index].getClassType() == "Integer") {
            Integer ival = new Integer(elemData.trim());
            return this.featureType.getAttributeType(index).parse((Object)ival);
        }
        return this.featureType.getAttributeType(index).parse((Object)elemData);
    }

    public String getFeatureID() {
        if (this.currentLine == null) {
            return null;
        }
        return this.currentLine.substring(5, 15).trim();
    }
}

