/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.tiger.TigerFeatureReader;
import org.geotools.data.tiger.TigerSchemaManager;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;

public class TigerDataStore
extends AbstractDataStore {
    protected File directory;

    public TigerDataStore(String dirName) {
        this(new File(dirName));
    }

    public TigerDataStore(File dir) {
        super(false);
        this.directory = dir;
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException(this.directory + " is not a directory!");
        }
    }

    public String[] getTypeNames() {
        String[] list = this.directory.list(new TigerFilenameFilter());
        String[] schemaTypeNames = TigerSchemaManager.getTypeNames();
        ArrayList<String> array = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].substring(0, list[i].lastIndexOf(46));
            for (int j = 0; j < schemaTypeNames.length; ++j) {
                array.add(list[i] + "_" + schemaTypeNames[j]);
            }
        }
        String[] typeNames = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            typeNames[i] = (String)array.get(i);
        }
        return typeNames;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        try {
            TigerSchemaManager manager = new TigerSchemaManager();
            FeatureType featureType = DataUtilities.createType((String)(this.directory.getName() + "." + typeName), (String)manager.getTypeSpec(typeName));
            return featureType;
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw new DataSourceException(typeName + " schema format error", (Throwable)e);
        }
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return new TigerFeatureReader(this.directory, typeName);
    }

    private class TigerFilenameFilter
    implements FilenameFilter {
        TigerFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith("RT1") || name.endsWith("rt1");
        }
    }
}

