/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.tiger.TigerDataStore;

public class TigerDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataStoreFactorySpi.Param DIRECTORY = new DataStoreFactorySpi.Param("directory", File.class, "Directory containing TIGER/Line 2002 files.");

    public DataStore createDataStore(Map params) throws IOException {
        File file = (File)DIRECTORY.lookUp(params);
        if (file.exists() && file.isDirectory()) {
            return new TigerDataStore(file);
        }
        throw new IOException();
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        String dirName = (String)params.get("directory");
        File dir = new File(dirName);
        if (dir.exists()) {
            throw new IOException("Can't create new data store: " + dir + " already exists!");
        }
        boolean created = dir.mkdir();
        if (!created) {
            throw new IOException("Can't create directory: " + dir);
        }
        return new TigerDataStore(dirName);
    }

    public String getDisplayName() {
        return "Tiger";
    }

    public String getDescription() {
        return "Data Store for TIGER/Line 2002 Line files.";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DIRECTORY};
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProcess(Map params) {
        try {
            File file = (File)DIRECTORY.lookUp(params);
            return file.exists() && file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

