/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.tiger.TigerAttributeReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class TigerFeatureReader
implements FeatureReader {
    private TigerAttributeReader reader;
    private String namespace;
    private String typeName;

    public TigerFeatureReader(File dir, String typeName) throws IOException {
        this.namespace = typeName.substring(0, typeName.indexOf("_"));
        this.typeName = typeName.substring(typeName.indexOf("_") + 1);
        File file = new File(dir, this.namespace + ".rt1");
        if (!file.exists()) {
            file = new File(dir, this.namespace + ".RT1");
        }
        if (!file.exists()) {
            throw new IOException("Can't read RT1 file.");
        }
        this.reader = new TigerAttributeReader(file, this.namespace, this.typeName);
    }

    public FeatureType getFeatureType() {
        return this.reader.getFeatureType();
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.reader.next();
        FeatureType type = this.reader.getFeatureType();
        String fid = this.reader.getFeatureID();
        int numAtts = this.reader.getAttributeCount();
        Object[] values = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            values[i] = this.reader.read(i);
        }
        return type.create(values, fid);
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }
}

