/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;

public class TigerGeometryAdapter {
    private final double SCALE_FACTOR = 1000000.0;
    private GeometryFactory geometryFactory;
    private BufferedReader rt2Reader;
    private int currentRow;
    private Hashtable type2s;
    private Coordinate nullCoord = new Coordinate(0.0, 0.0);

    public TigerGeometryAdapter(BufferedReader rt2Reader) {
        this.rt2Reader = rt2Reader;
        try {
            this.type2s = new Hashtable();
            this.currentRow = -1;
            this.loadType2Recs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.geometryFactory = new GeometryFactory();
    }

    public Geometry deSerialize(String featureId, String line) {
        CoordinateList list = new CoordinateList();
        double x1 = Double.parseDouble(line.substring(190, 200));
        double y1 = Double.parseDouble(line.substring(200, 209));
        double xn = Double.parseDouble(line.substring(209, 219));
        double yn = Double.parseDouble(line.substring(219, 228));
        list.add((Object)new Coordinate(x1 / 1000000.0, y1 / 1000000.0));
        String buff = null;
        int i = 1;
        Type2Record rec = new Type2Record();
        rec.mTlid = Integer.parseInt(featureId);
        while (true) {
            rec.Ordinal = i++;
            buff = (String)this.type2s.get(rec.getKey());
            if (buff == null) break;
            this.getCoordinates(buff, list);
        }
        list.add((Object)new Coordinate(xn / 1000000.0, yn / 1000000.0));
        return this.geometryFactory.createLineString(list.toCoordinateArray());
    }

    private void getCoordinates(String buff, CoordinateList list) {
        double y;
        double x;
        Coordinate c;
        int startPos = 18;
        int increment = 19;
        for (int i = 0; i < 10 && !this.nullCoord.equals2D(c = new Coordinate((x = Double.parseDouble(buff.substring(startPos, startPos + 10).trim())) / 1000000.0, (y = Double.parseDouble(buff.substring(startPos + 10, startPos + 19).trim())) / 1000000.0)); ++i) {
            list.add((Object)c);
            startPos += increment;
        }
    }

    private LineString createLineString(double[] elems) {
        CoordinateList list = new CoordinateList();
        if (elems.length != 0 && elems.length < 4) {
            return null;
        }
        if (elems.length % 2 != 0) {
            return null;
        }
        for (int i = 0; i < elems.length; i += 2) {
            list.add((Object)new Coordinate(elems[i], elems[i + 1]));
        }
        return this.geometryFactory.createLineString(CoordinateArrays.toCoordinateArray((Collection)list));
    }

    private void loadType2Recs() throws IOException {
        String buffer;
        while ((buffer = this.rt2Reader.readLine()) != null) {
            Type2Record rec = new Type2Record();
            rec.mTlid = Integer.parseInt(buffer.substring(5, 15).trim());
            rec.Ordinal = Integer.parseInt(buffer.substring(15, 18).trim());
            this.type2s.put(rec.getKey(), buffer);
        }
    }

    private class Type2Record {
        int mTlid;
        int Ordinal;

        private Type2Record() {
        }

        public Integer getKey() {
            return new Integer(this.mTlid * 100 + this.Ordinal);
        }
    }
}

