/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.tiger;

import java.util.Hashtable;
import org.geotools.data.tiger.TigerSchemaElement;

public class TigerSchemaManager {
    private static final String[] typeNames = new String[]{"HIGHWAYS", "RAILROADS", "OTHER_TRANSPORTATION", "HYDROGRAPHY", "LANDMARKS", "PHYSICAL_FEATURES"};
    private static final String[] typeNameKeys = new String[]{"A", "B", "C", "H", "D", "E"};
    private TigerSchemaElement[] highwayAttributes = new TigerSchemaElement[14];
    private TigerSchemaElement[] railroadAttributes;
    private TigerSchemaElement[] otherTransAttributes;
    private TigerSchemaElement[] hydroAttributes;
    private TigerSchemaElement[] landmarkAttributes;
    private TigerSchemaElement[] physicalAttributes;
    private Hashtable schemaMapping;
    private Hashtable typeNameKey;

    public TigerSchemaManager() {
        this.highwayAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.highwayAttributes[1] = new TigerSchemaElement("Fedirp", "String", 17, 19);
        this.highwayAttributes[2] = new TigerSchemaElement("Fename", "String", 19, 49);
        this.highwayAttributes[3] = new TigerSchemaElement("Fetype", "String", 49, 53);
        this.highwayAttributes[4] = new TigerSchemaElement("Fedirs", "String", 53, 55);
        this.highwayAttributes[5] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.highwayAttributes[6] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.highwayAttributes[7] = new TigerSchemaElement("Fraddl", "String", 58, 69);
        this.highwayAttributes[8] = new TigerSchemaElement("Toaddl", "String", 69, 80);
        this.highwayAttributes[9] = new TigerSchemaElement("Fraddr", "String", 80, 91);
        this.highwayAttributes[10] = new TigerSchemaElement("Toaddr", "String", 91, 102);
        this.highwayAttributes[11] = new TigerSchemaElement("Zipl", "String", 106, 111);
        this.highwayAttributes[12] = new TigerSchemaElement("Zipr", "String", 111, 116);
        this.highwayAttributes[13] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.railroadAttributes = new TigerSchemaElement[5];
        this.railroadAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.railroadAttributes[1] = new TigerSchemaElement("Name", "String", 19, 49);
        this.railroadAttributes[2] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.railroadAttributes[3] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.railroadAttributes[4] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.hydroAttributes = new TigerSchemaElement[5];
        this.hydroAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.hydroAttributes[1] = new TigerSchemaElement("Name", "String", 19, 49);
        this.hydroAttributes[2] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.hydroAttributes[3] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.hydroAttributes[4] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.otherTransAttributes = new TigerSchemaElement[5];
        this.otherTransAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.otherTransAttributes[1] = new TigerSchemaElement("Name", "String", 19, 49);
        this.otherTransAttributes[2] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.otherTransAttributes[3] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.otherTransAttributes[4] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.landmarkAttributes = new TigerSchemaElement[5];
        this.landmarkAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.landmarkAttributes[1] = new TigerSchemaElement("Name", "String", 19, 49);
        this.landmarkAttributes[2] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.landmarkAttributes[3] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.landmarkAttributes[4] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.physicalAttributes = new TigerSchemaElement[5];
        this.physicalAttributes[0] = new TigerSchemaElement("TLID", "Integer", 5, 15);
        this.physicalAttributes[1] = new TigerSchemaElement("Name", "String", 19, 49);
        this.physicalAttributes[2] = new TigerSchemaElement("Ctype", "String", 55, 56);
        this.physicalAttributes[3] = new TigerSchemaElement("Ccode", "String", 56, 58);
        this.physicalAttributes[4] = new TigerSchemaElement("Geometry", "Geometry", -1, -1);
        this.schemaMapping = new Hashtable();
        this.schemaMapping.put(typeNames[0], this.highwayAttributes);
        this.schemaMapping.put(typeNames[1], this.railroadAttributes);
        this.schemaMapping.put(typeNames[2], this.otherTransAttributes);
        this.schemaMapping.put(typeNames[3], this.hydroAttributes);
        this.schemaMapping.put(typeNames[4], this.landmarkAttributes);
        this.schemaMapping.put(typeNames[5], this.physicalAttributes);
        this.typeNameKey = new Hashtable();
        for (int i = 0; i < typeNames.length; ++i) {
            this.typeNameKey.put(typeNames[i], typeNameKeys[i]);
        }
    }

    public static String[] getTypeNames() {
        return typeNames;
    }

    public TigerSchemaElement[] getSchema(String typeName) {
        TigerSchemaElement[] schema = (TigerSchemaElement[])this.schemaMapping.get(typeName);
        if (null == schema) {
            String typeNameString = TigerSchemaManager.getTypeSubNameString(typeName);
            schema = (TigerSchemaElement[])this.schemaMapping.get(typeNameString);
        }
        return schema;
    }

    public String getTypeSpec(String typeName) {
        TigerSchemaElement[] atts = this.getSchema(typeName);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < atts.length; ++i) {
            buffer.append(atts[i].getAttributeName());
            buffer.append(":");
            buffer.append(atts[i].getClassType());
            if (i == atts.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    protected String getTypeKey(String typeName) {
        return (String)this.typeNameKey.get(typeName);
    }

    public static String getTypeSubNameString(String inputName) {
        int index = inputName.indexOf("_");
        if (index > 0) {
            return inputName.substring(index + 1);
        }
        return inputName;
    }
}

