/*
 * Decompiled with CFR 0.152.
 */
package org.openplans.spatialDBbox;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.openplans.spatialDBbox.AutoCodeGenerator;
import org.openplans.spatialDBbox.PostgisCPPCodeGenerator;

public class PostgisCCodeGenerator
extends AutoCodeGenerator {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void preambleCodeFunction(Method m, PrintStream printstream) {
        printstream.print("extern  ");
        PostgisCPPCodeGenerator.prototypeFunction(m, printstream);
        printstream.println(";");
    }

    public void preambleCode(PrintStream printstream) {
        printstream.println("//\t\t (C) 2005 by David Blasby and The Open Planning Project ");
        printstream.println("//\t\t http://openplans.org ");
        printstream.println("// ");
        printstream.println("//\t\t Released under the LGPL ");
        printstream.println("// ");
        printstream.println("//\t\t contact: dblasby@openplans.org ");
        printstream.println("#include <math.h>");
        printstream.println("#include <float.h>");
        printstream.println("#include <string.h>");
        printstream.println("#include <stdio.h>");
        printstream.println("#include <errno.h>");
        printstream.println("#include \"postgres.h\"");
        printstream.println("#include \"fmgr.h\"");
        printstream.println("#include \"utils/elog.h\"");
        printstream.println("");
        printstream.println("typedef  struct Geometry Geometry;");
        PostgisCPPCodeGenerator.commonDefs(printstream);
        printstream.println("");
        printstream.println("");
        printstream.println("");
        printstream.println("");
    }

    public void preambleCode2(PrintStream ps) {
        this.helperfunctions(ps);
    }

    public void helperfunctions(PrintStream printstream) {
        printstream.println("char *text_to_cstring(text *t)");
        printstream.println("{");
        printstream.println(" \tint input_len  = VARATT_SIZEP(t)-4;");
        printstream.println("\tchar *str = palloc(input_len+1);");
        printstream.println("\tmemcpy(str,VARDATA(t),input_len);");
        printstream.println("\tstr[input_len] = 0;");
        printstream.println("\treturn str;");
        printstream.println("}");
        printstream.println("");
        printstream.println("//in comes straight from the DB (after detoasting)");
        printstream.println("Geometry *deserializeGeometry(char *in)");
        printstream.println("{");
        printstream.println("\tchar *wkt =  text_to_cstring( (text*) in);");
        printstream.println("        RETURNTYPE r = JTSCPP_geomFromWKT(wkt);");
        printstream.println("        pfree (wkt);");
        printstream.println("\tif (r.type == TYPE_ERROR)");
        printstream.println("\t{");
        printstream.println("\t    if (r.data.ptr == NULL)");
        printstream.println("                elog(ERROR,\"UNKNOWN JTS ERROR\");");
        printstream.println("");
        printstream.println("                char *msg = (char*)palloc( strlen(r.data.ptr) +1);");
        printstream.println("                memcpy(msg,r.data.ptr,strlen(r.data.ptr) +1);");
        printstream.println("                free(r.data.ptr);");
        printstream.println("\t\telog(ERROR,msg);");
        printstream.println("\t}");
        printstream.println("\treturn r.data.g;");
        printstream.println("}");
        printstream.println("");
        printstream.println("//send result of this direct to DB");
        printstream.println("char *serializeGeometry(Geometry *g)");
        printstream.println("{");
        printstream.println("\tRETURNTYPE r = JTSCPP_toText(g);");
        printstream.println("\tif (r.type == TYPE_ERROR)");
        printstream.println("\t{");
        printstream.println("\t    if (r.data.ptr == NULL)");
        printstream.println("                elog(ERROR,\"UNKNOWN JTS ERROR\");");
        printstream.println("");
        printstream.println("                char *msg = (char*)palloc( strlen(r.data.ptr) +1);");
        printstream.println("                memcpy(msg,r.data.ptr,strlen(r.data.ptr) +1);");
        printstream.println("                free(r.data.ptr);");
        printstream.println("\t\telog(ERROR,msg);");
        printstream.println("\t}");
        printstream.println("\tint len = strlen(r.data.ptr);");
        printstream.println("\ttext *result =  palloc( len+4 ); // dont need null term");
        printstream.println("\tmemcpy(VARDATA(result), r.data.ptr, len);");
        printstream.println("\tVARATT_SIZEP(result) = len+4;");
        printstream.println("\tfree(r.data.ptr);");
        printstream.println("\treturn (char*)result;\t");
        printstream.println("}");
        printstream.println("text *cstring_to_text(char *c)");
        printstream.println("{");
        printstream.println(" \ttext *result;");
        printstream.println("\t\t\t");
        printstream.println("\tint len = strlen(c);");
        printstream.println("\tresult =  palloc( len+4 ); // dont need null term");
        printstream.println("\tmemcpy(VARDATA(result), c, len);");
        printstream.println("\tVARATT_SIZEP(result) = len+4;");
        printstream.println("");
        printstream.println("\treturn result;");
        printstream.println("}");
    }

    public void postscriptCode(PrintStream printstream) {
    }

    public static String formatClassName(Class c) {
        String result = PostgisCPPCodeGenerator.formatClassName(c);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            return "char";
        }
        return result;
    }

    public void functionParameters(Method m, PrintStream printstream) {
        int t = 0;
        while (t < m.getParameterTypes().length) {
            Class<?> param = m.getParameterTypes()[t];
            printstream.print("     " + PostgisCCodeGenerator.formatClassName(param) + " ");
            if (PostgisCPPCodeGenerator.isObj(param)) {
                printstream.print("*");
            }
            printstream.println("arg" + t + " = " + this.getdeserialized(param, t));
            ++t;
        }
    }

    private String getdeserialized(Class param, int t) {
        if (param == Double.TYPE) {
            return "PG_GETARG_FLOAT8(" + t + ");";
        }
        if (param == Integer.TYPE) {
            return "PG_GETARG_INT32(" + t + ");";
        }
        if (param == Boolean.TYPE) {
            return "PG_GETARG_BOOL(" + t + ");";
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("com.vividsolutions.jts.geom.Geometry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (param == clazz) {
            return "deserializeGeometry(    (char *)PG_DETOAST_DATUM(PG_GETARG_DATUM(" + t + "))   );";
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (param == clazz2) {
            return "text_to_cstring(  (text *)PG_DETOAST_DATUM(PG_GETARG_DATUM(" + t + "))  );";
        }
        throw new IllegalArgumentException("");
    }

    public static String convertFunctionName(Method m) {
        return "JTS_" + PostgisCPPCodeGenerator.convertFunctionName(m.getName());
    }

    public void emitCode(Method m, PrintStream printstream) {
        printstream.println("PG_FUNCTION_INFO_V1(" + PostgisCCodeGenerator.convertFunctionName(m) + ");");
        printstream.println("Datum " + PostgisCCodeGenerator.convertFunctionName(m) + "(PG_FUNCTION_ARGS)");
        printstream.println("{");
        this.functionParameters(m, printstream);
        printstream.println("");
        this.callfunction(m, printstream);
        this.freeup(m, printstream);
        this.returnresult(m, printstream);
        printstream.println("}");
        printstream.println("");
    }

    private void returnresult(Method m, PrintStream printstream) {
        Class<?> returntype = m.getReturnType();
        if (returntype == Double.TYPE) {
            printstream.println("      PG_RETURN_FLOAT8(result.data.float8);");
        } else if (returntype == Integer.TYPE) {
            printstream.println("      PG_RETURN_INT32(result.data.integer);");
        } else if (returntype == Boolean.TYPE) {
            printstream.println("      PG_RETURN_BOOL(result.data.b);");
        } else {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("com.vividsolutions.jts.geom.Geometry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (returntype == clazz) {
                printstream.println("      PG_RETURN_POINTER( serializeGeometry(result.data.g) );");
            } else {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (returntype == clazz2) {
                    printstream.println("      text *r = cstring_to_text(result.data.ptr);");
                    printstream.println("      free(result.data.ptr);");
                    printstream.println("      PG_RETURN_POINTER( r );");
                } else {
                    throw new IllegalArgumentException("");
                }
            }
        }
    }

    private void freeup(Method m, PrintStream printstream) {
        int t = 0;
        while (t < m.getParameterTypes().length) {
            Class<?> param = m.getParameterTypes()[t];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (param == clazz) {
                printstream.println("       PG_FREE_IF_COPY(arg" + t + "," + t + ");");
            }
            ++t;
        }
    }

    private void callfunction(Method m, PrintStream printstream) {
        printstream.print("      RETURNTYPE result = ");
        printstream.print(" JTSCPP_" + PostgisCPPCodeGenerator.convertFunctionName(m) + "(");
        int t = 0;
        while (t < m.getParameterTypes().length) {
            printstream.print("arg" + t);
            if (t != m.getParameterTypes().length - 1) {
                printstream.print(",");
            }
            ++t;
        }
        printstream.println(");");
        printstream.println("      if (result.type == TYPE_ERROR)");
        printstream.println("      {");
        printstream.println("            if (result.data.ptr == NULL)");
        printstream.println("                    elog(ERROR,\"UNKNOWN JTS ERROR\");");
        printstream.println("                    ");
        printstream.println("                    char *msg = (char*)palloc( strlen(result.data.ptr) +1);");
        printstream.println("                    memcpy(msg,result.data.ptr,strlen(result.data.ptr) +1);");
        printstream.println("                    free(result.data.ptr);");
        printstream.println("                    elog(ERROR,msg);");
        printstream.println("      }");
    }

    public static void main(String[] args) {
        PostgisCCodeGenerator _this = new PostgisCCodeGenerator();
        _this.generateFile("stdio");
    }
}

