/*
 * Decompiled with CFR 0.152.
 */
package org.openplans.spatialDBbox;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.openplans.spatialDBbox.AutoCodeGenerator;

public class PostgisCPPCodeGenerator
extends AutoCodeGenerator {
    static /* synthetic */ Class class$0;

    public static void helperFunctions(PrintStream printstream) {
        printstream.println("// set cpyMsg to true if you want a copy of");
        printstream.println("// msg to be put in the return.");
        printstream.println("RETURNTYPE createErrorReturn(char *msg, char copyMsg)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println(" ");
        printstream.println("   r.type = TYPE_ERROR;");
        printstream.println("   if (copyMsg)");
        printstream.println("   {");
        printstream.println("       char *cpy = (char*)malloc( strlen(msg)+1 );");
        printstream.println("       memcpy(cpy,msg, strlen(msg)+1);");
        printstream.println("       r.data.ptr = (void *) cpy;");
        printstream.println("   }");
        printstream.println("   else");
        printstream.println("   {");
        printstream.println("   \tr.data.ptr  = (void*) msg;");
        printstream.println("   }");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("");
        printstream.println("RETURNTYPE createjstringErrorReturn(jstring msg)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("   r.type = TYPE_ERROR;");
        printstream.println("  \t int length = JvGetStringUTFLength(msg);");
        printstream.println("  \t char *result = (char *) malloc(length+1);");
        printstream.println("  \t JvGetStringUTFRegion(msg, 0, length, result);");
        printstream.println("  \t result[length] = 0;  //null terminate");
        printstream.println("   r.data.ptr =(void*) result;");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("");
        printstream.println("RETURNTYPE createGeometryReturn(Geometry *g)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("   r.data.g  =  g;");
        printstream.println("   r.type =  TYPE_PTR_GEOM;   ");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("RETURNTYPE createintReturn(int i)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("   r.data.integer  =  i;");
        printstream.println("   r.type =  TYPE_INT ;   ");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("RETURNTYPE createbooleanReturn(char boolean)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("   r.data.b  =  boolean;");
        printstream.println("   r.type =  TYPE_BOOLEAN;   ");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("RETURNTYPE createdoubleReturn(double d)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("   r.data.float8  =  d;");
        printstream.println("   r.type =  TYPE_DOUBLE;   ");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("// 'C' program should free result!");
        printstream.println("RETURNTYPE createcharReturn(jstring str)");
        printstream.println("{");
        printstream.println("   RETURNTYPE r;");
        printstream.println("     \t int length = JvGetStringUTFLength(str);");
        printstream.println("  \t char *result = (char *) malloc(length+1);");
        printstream.println("  \t JvGetStringUTFRegion(str, 0, length, result);");
        printstream.println("  \t result[length] = 0;  //null terminate");
        printstream.println("   r.data.ptr =(void*) result;");
        printstream.println("   r.type =  TYPE_PTR_CHAR;   ");
        printstream.println("   return r;");
        printstream.println("}");
        printstream.println("");
        printstream.println("");
        printstream.println("void JTSsetup()");
        printstream.println("{");
        printstream.println("   if (!(initialized))");
        printstream.println("   {");
        printstream.println("\t JvCreateJavaVM(NULL);");
        printstream.println("         JvAttachCurrentThread(NULL, NULL);");
        printstream.println("");
        printstream.println("");
        printstream.println("        JvInitClass(&Geometry::class$);");
        printstream.println("        JvInitClass(&StaticGeometry::class$);");
        printstream.println("        JvInitClass(&String::class$);");
        printstream.println("        initialized = 1; // dont redo this");
        printstream.println("   }");
        printstream.println("}");
    }

    public static void commonDefs(PrintStream printstream) {
        printstream.println("#define TYPE_ERROR   0");
        printstream.println("#define TYPE_BOOLEAN 1");
        printstream.println("#define TYPE_PTR_GEOM 2");
        printstream.println("#define TYPE_PTR_CHAR 3");
        printstream.println("#define TYPE_INT      10");
        printstream.println("#define TYPE_DOUBLE   11");
        printstream.println("");
        printstream.println("// if a function returns return.type== TYPE_ERROR an");
        printstream.println("// error occured, otherwise look at return.type and");
        printstream.println("// pull out the info.");
        printstream.println("// if (return.type == TYPE_INT)");
        printstream.println("//    result = return.data.integer;");
        printstream.println("//...");
        printstream.println("// 'C' program is required to free the info in a (char*)");
        printstream.println("// garbage collector will take care of Geometry *");
        printstream.println("typedef struct ab");
        printstream.println("{");
        printstream.println("    char  type;");
        printstream.println("   union  ");
        printstream.println("   {");
        printstream.println("      char   b;");
        printstream.println("      void   *ptr;     //generic pointer type");
        printstream.println("      Geometry *g;");
        printstream.println("      int    integer;");
        printstream.println("      double float8;");
        printstream.println("  } data;");
        printstream.println("} RETURNTYPE;");
    }

    public static String formatClassName(Class c) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            return "char";
        }
        return AutoCodeGenerator.formatClassName(c);
    }

    public static boolean isObj(Class c) {
        return !c.isPrimitive();
    }

    public static void prototypeFunction(Method m, PrintStream printstream) {
        printstream.print("RETURNTYPE JTSCPP_" + AutoCodeGenerator.convertFunctionName(m) + "(");
        int t = 0;
        while (t < m.getParameterTypes().length) {
            Class<?> param = m.getParameterTypes()[t];
            printstream.print(String.valueOf(PostgisCPPCodeGenerator.formatClassName(param)) + " ");
            if (PostgisCPPCodeGenerator.isObj(param)) {
                printstream.print("*");
            }
            printstream.print("arg" + t);
            if (t != m.getParameterTypes().length - 1) {
                printstream.print(",");
            }
            ++t;
        }
        printstream.print(")");
    }

    public void preambleCodeFunction(Method m, PrintStream printstream) {
        printstream.print("extern \"C\" ");
        PostgisCPPCodeGenerator.prototypeFunction(m, printstream);
        printstream.println(";");
    }

    public void preambleCode(PrintStream printstream) {
        printstream.println("#pragma GCC java_exceptions");
        printstream.println("");
        printstream.println("//\t\t (C) 2005 by David Blasby and The Open Planning Project ");
        printstream.println("//\t\t http://openplans.org ");
        printstream.println("// ");
        printstream.println("//\t\t Released under the LGPL ");
        printstream.println("// ");
        printstream.println("//\t\t contact: dblasby@openplans.org ");
        printstream.println("#include \"Geometry.h\"");
        printstream.println("#include \"StaticGeometry.h\"");
        printstream.println("#include <java/lang/Throwable.h>");
        printstream.println("#include <gcj/cni.h>");
        printstream.println("#include <stdio.h>");
        printstream.println("#include <java/lang/String.h>");
        printstream.println("#include <malloc.h>");
        printstream.println("");
        printstream.println("");
        printstream.println("");
        printstream.println("    using namespace java::lang;");
        printstream.println("    using namespace com::vividsolutions::jts::geom;");
        printstream.println("    using namespace org::openplans::spatialDBbox;");
        printstream.println("");
        PostgisCPPCodeGenerator.commonDefs(printstream);
        printstream.println("");
        printstream.println("");
        printstream.println("char initialized = 0; //1 when connected to garbage collector");
        printstream.println("");
        printstream.println("");
        PostgisCPPCodeGenerator.helperFunctions(printstream);
        printstream.println("");
        printstream.println("");
    }

    public void postscriptCode(PrintStream printstream) {
        printstream.println("//end of file");
    }

    public void emitCode(Method m, PrintStream printstream) {
        PostgisCPPCodeGenerator.prototypeFunction(m, printstream);
        printstream.println("");
        printstream.println("{");
        printstream.println("     JTSsetup(); // just in case!");
        printstream.println("");
        this.verifyNoNullArgs(m, printstream);
        printstream.println("    try {");
        printstream.print("         return create" + PostgisCPPCodeGenerator.formatClassName(m.getReturnType()) + "Return ( StaticGeometry::" + m.getName() + "(");
        int t = 0;
        while (t < m.getParameterTypes().length) {
            Class<?> param = m.getParameterTypes()[t];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (param == clazz) {
                printstream.print("  JvNewStringLatin1(arg" + t + ")  ");
            } else {
                printstream.print("arg" + t);
            }
            if (t != m.getParameterTypes().length - 1) {
                printstream.print(",");
            }
            ++t;
        }
        printstream.println(")  );");
        printstream.println("    }");
        printstream.println("    catch (java::lang::Throwable *e)");
        printstream.println("    {");
        printstream.println("     \treturn createjstringErrorReturn( e->toString() );");
        printstream.println("    }");
        printstream.println("}");
        printstream.println("");
    }

    private void verifyNoNullArgs(Method m, PrintStream printstream) {
        int t = 0;
        while (t < m.getParameterTypes().length) {
            Class<?> param = m.getParameterTypes()[t];
            if (!param.isPrimitive()) {
                printstream.println("    if (arg" + t + " == NULL)");
                printstream.println("    {");
                printstream.println("         return createErrorReturn(\"" + AutoCodeGenerator.convertFunctionName(m) + " - argument #" + t + " is NULL\",1);");
                printstream.println("    }");
            }
            ++t;
        }
    }

    public static void main(String[] args) {
        PostgisCPPCodeGenerator _this = new PostgisCPPCodeGenerator();
        _this.generateFile("stdio");
    }
}

