/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.property;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.DataStoreService;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.property.PropertyGeoResource;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.util.ProgressListener;

public class PropertyService
extends DataStoreService {
    File directory;

    public PropertyService(Catalog parent, Map params, File directory) {
        super(parent, params);
        this.directory = directory;
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee != null && adaptee.isAssignableFrom(File.class)) {
            return true;
        }
        return super.canResolve(adaptee);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee != null && adaptee.isAssignableFrom(File.class)) {
            return this.directory;
        }
        return super.resolve(adaptee, monitor);
    }

    protected DataStoreFactorySpi createDataStoreFactory() {
        return new PropertyDataStoreFactory();
    }

    protected GeoResource createGeoResource(String typeName, DataStore dataStore) {
        return new PropertyGeoResource(this, typeName);
    }

    protected ServiceInfo createMetaData(DataStore dataStore, ProgressListener monitor) {
        String namespace = null;
        try {
            namespace = (String)PropertyDataStoreFactory.NAMESPACE.lookUp(this.getConnectionParams());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error looking up namespace", e);
        }
        if (namespace == null) {
            return super.createMetaData(dataStore, monitor);
        }
        DefaultServiceInfo info = (DefaultServiceInfo)super.createMetaData(dataStore, monitor);
        try {
            info.setSchema(new URI(namespace));
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Error parsing namespace:" + namespace, e);
        }
        return info;
    }

    public URI getIdentifier() {
        return this.directory.toURI();
    }
}

