/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.property;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFactory;
import org.geotools.catalog.property.PropertyService;
import org.geotools.data.property.PropertyDataStoreFactory;

public class PropertyServiceFactory
implements ServiceFactory {
    public Service createService(Catalog catalog, URI uri, Map params) {
        if (params.containsKey(PropertyDataStoreFactory.DIRECTORY.key)) {
            File file;
            try {
                file = (File)PropertyDataStoreFactory.DIRECTORY.lookUp(params);
            }
            catch (IOException e) {
                return null;
            }
            if (file != null) {
                return new PropertyService(catalog, params, file);
            }
        }
        return null;
    }

    public boolean canProcess(URI uri) {
        try {
            File file = new File(uri.toURL().getFile());
            return file.isDirectory() && file.canRead() && PropertyServiceFactory.containsPropertyFile(file);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Map createParams(URI uri) {
        File file;
        if (!this.canProcess(uri)) {
            return null;
        }
        try {
            file = new File(uri.toURL().getFile());
        }
        catch (MalformedURLException e) {
            return null;
        }
        HashMap<String, File> map = new HashMap<String, File>();
        map.put(PropertyDataStoreFactory.DIRECTORY.key, file);
        return map;
    }

    static boolean containsPropertyFile(File dir) {
        if (dir.isDirectory()) {
            dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String s = ".properties";
                    if (name.length() > s.length()) {
                        return s.equals(name.substring(s.length()));
                    }
                    return false;
                }
            });
        }
        return false;
    }
}

