/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;

public class PropertyAttributeReader
implements AttributeReader {
    private static final WKTReader wktReader = new WKTReader(new GeometryFactory());
    BufferedReader reader;
    FeatureType type;
    String line;
    String next;
    String[] text;
    String fid;

    public PropertyAttributeReader(File file) throws IOException {
        String typeName = PropertyAttributeReader.typeName(file);
        String namespace = PropertyAttributeReader.namespace(file);
        this.reader = new BufferedReader(new FileReader(file));
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("_=")) {
        }
        if (this.line == null || !this.line.startsWith("_=")) {
            throw new IOException(typeName + " schema not available");
        }
        String typeSpec = this.line.substring(2);
        try {
            this.type = DataUtilities.createType((String)(namespace + typeName), (String)typeSpec);
        }
        catch (SchemaException e) {
            throw new DataSourceException(typeName + " schema not available", (Throwable)e);
        }
        this.line = null;
        this.next = null;
    }

    private static String typeName(File file) {
        String name = file.getName();
        int split = name.lastIndexOf(46);
        return split == -1 ? name : name.substring(0, split);
    }

    private static String namespace(File file) {
        File parent = file.getParentFile();
        return parent == null ? "" : parent.getName() + ".";
    }

    public int getAttributeCount() {
        return this.type.getAttributeCount();
    }

    public AttributeType getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.type.getAttributeType(index);
    }

    public void close() throws IOException {
        this.reader.close();
        this.reader = null;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.reader.readLine();
        return this.next != null;
    }

    public void next() throws IOException {
        if (this.hasNext()) {
            this.line = this.next;
            this.next = null;
            int split = this.line.indexOf(61);
            this.fid = this.line.substring(0, split);
            this.text = this.line.substring(split + 1).split("\\|");
            if (this.type.getAttributeCount() != this.text.length) {
                throw new DataSourceException("format error: expected " + this.type.getAttributeCount() + " attributes, but found " + this.text.length + ". [" + this.line + "]");
            }
        } else {
            throw new NoSuchElementException();
        }
    }

    public String getFeatureID() {
        if (this.line == null) {
            return null;
        }
        return this.fid;
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        if (this.line == null) {
            throw new IOException("No content available - did you remeber to call next?");
        }
        AttributeType attType = this.type.getAttributeType(index);
        String stringValue = null;
        try {
            stringValue = this.text[index];
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
            stringValue = null;
        }
        Object value = null;
        if (attType instanceof GeometryAttributeType) {
            try {
                value = wktReader.read(stringValue);
            }
            catch (ParseException e) {
                throw new DataSourceException("Can't parse WKT for fid#" + this.fid, (Throwable)e);
            }
        } else {
            value = attType.parse((Object)stringValue);
        }
        return value;
    }
}

