/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.data.property.PropertyFeatureSource;
import org.geotools.data.property.PropertyFeatureWriter;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;

public class PropertyDataStore
extends AbstractDataStore {
    protected File directory;

    public PropertyDataStore(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this.directory = dir;
    }

    public String[] getTypeNames() {
        String[] list = this.directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].substring(0, list[i].lastIndexOf(46));
        }
        return list;
    }

    public FeatureType getSchema(String typeName) throws IOException {
        String namespace = this.property(typeName, "namespace");
        if (namespace == null) {
            namespace = this.directory.getName();
        }
        String typeSpec = this.property(typeName, "_");
        try {
            return DataUtilities.createType((String)(namespace + "." + typeName), (String)typeSpec);
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw new DataSourceException(typeName + " schema not available", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String property(String typeName, String key) throws IOException {
        File file = new File(this.directory, typeName + ".properties");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(key + "=")) {
                    String string = line.substring(key.length() + 1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        return new PropertyFeatureReader(this.directory, typeName);
    }

    protected FeatureWriter getFeatureWriter(String typeName) throws IOException {
        return new PropertyFeatureWriter(this, typeName);
    }

    public void createSchema(FeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        File file = new File(this.directory, typeName + ".properties");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("_=");
        writer.write(DataUtilities.spec((FeatureType)featureType));
        writer.close();
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        return new PropertyFeatureSource(this, typeName);
    }
}

