/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.property.PropertyDataStore;

public class PropertyDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logger.getLogger(PropertyDataStoreFactory.class.getPackage().getName());
    public static final DataStoreFactorySpi.Param DIRECTORY = new DataStoreFactorySpi.Param("directory", File.class, "Directory containting property files", true);
    public static final DataStoreFactorySpi.Param NAMESPACE = new DataStoreFactorySpi.Param("namespace", String.class, "namespace of datastore", false);

    public DataStore createDataStore(Map params) throws IOException {
        File dir = this.directoryLookup(params);
        if (dir.exists() && dir.isDirectory()) {
            return new PropertyDataStore(dir);
        }
        throw new IOException("Directory is required");
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        File dir = this.directoryLookup(params);
        if (dir.exists()) {
            throw new IOException(dir + " already exists");
        }
        boolean created = dir.mkdir();
        if (!created) {
            throw new IOException("Could not create the directory" + dir);
        }
        return new PropertyDataStore(dir);
    }

    public String getDisplayName() {
        return "Properties";
    }

    public String getDescription() {
        return "Allows access to Java Property files containing Feature information";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{DIRECTORY};
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProcess(Map params) {
        try {
            this.directoryLookup(params);
            return true;
        }
        catch (Exception erp) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "can't process parameters", erp);
            }
            return false;
        }
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    private File directoryLookup(Map params) throws IOException, FileNotFoundException, IllegalArgumentException {
        File directory = (File)DIRECTORY.lookUp(params);
        if (!directory.exists()) {
            File currentDir = new File(System.getProperty("user.dir"));
            directory = new File(currentDir, (String)params.get(PropertyDataStoreFactory.DIRECTORY.key));
            if (!directory.exists()) {
                throw new FileNotFoundException(directory.getAbsolutePath());
            }
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
            }
        }
        return directory;
    }
}

