/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.property.PropertyAttributeReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class PropertyFeatureReader
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.property");
    PropertyAttributeReader reader;

    public PropertyFeatureReader(File directory, String typeName) throws IOException {
        File file = new File(directory, typeName + ".properties");
        this.reader = new PropertyAttributeReader(file);
    }

    public FeatureType getFeatureType() {
        return this.reader.type;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        this.reader.next();
        FeatureType type = this.reader.type;
        String fid = this.reader.getFeatureID();
        Object[] values = new Object[this.reader.getAttributeCount()];
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            try {
                values[i] = this.reader.read(i);
                continue;
            }
            catch (RuntimeException e) {
                values[i] = null;
                continue;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return type.create(values, fid);
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.reader == null) {
            LOGGER.warning("Stream seems to be already closed.");
        } else {
            this.reader.close();
        }
        this.reader = null;
    }
}

