/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyAttributeReader;
import org.geotools.data.property.PropertyAttributeWriter;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class PropertyFeatureWriter
implements FeatureWriter {
    PropertyDataStore store;
    File read;
    PropertyAttributeReader reader;
    File write;
    PropertyAttributeWriter writer;
    Feature origional = null;
    Feature live = null;

    public PropertyFeatureWriter(PropertyDataStore dataStore, String typeName) throws IOException {
        this.store = dataStore;
        File dir = this.store.directory;
        this.read = new File(dir, typeName + ".properties");
        this.write = File.createTempFile(typeName + System.currentTimeMillis(), null, dir);
        this.reader = new PropertyAttributeReader(this.read);
        this.writer = new PropertyAttributeWriter(this.write, this.reader.type);
    }

    public FeatureType getFeatureType() {
        return this.reader.type;
    }

    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        if (this.live != null && this.origional != null) {
            this.writeImplementation(this.origional);
            this.origional = null;
            this.live = null;
        }
        return this.reader.hasNext();
    }

    private void writeImplementation(Feature f) throws IOException {
        this.writer.next();
        this.writer.writeFeatureID(f.getID());
        for (int i = 0; i < f.getNumberOfAttributes(); ++i) {
            this.writer.write(i, f.getAttribute(i));
        }
    }

    public Feature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        String fid = null;
        FeatureType type = this.reader.type;
        try {
            if (this.hasNext()) {
                this.reader.next();
                fid = this.reader.getFeatureID();
                Object[] values = new Object[this.reader.getAttributeCount()];
                for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                    values[i] = this.reader.read(i);
                }
                this.origional = type.create(values, fid);
                this.live = type.duplicate(this.origional);
                return this.live;
            }
            fid = type.getTypeName() + "." + System.currentTimeMillis();
            Object[] values = DataUtilities.defaultValues((FeatureType)type);
            this.origional = null;
            this.live = type.create(values, fid);
            return this.live;
        }
        catch (IllegalAttributeException e) {
            String message = "Problem creating feature " + (fid != null ? fid : "");
            throw new DataSourceException(message, (Throwable)e);
        }
    }

    public void write() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to write");
        }
        if (this.live.equals(this.origional)) {
            this.writeImplementation(this.origional);
        } else {
            this.writeImplementation(this.live);
            if (this.origional != null) {
                Envelope bounds = new Envelope();
                bounds.expandToInclude(this.live.getBounds());
                bounds.expandToInclude(this.origional.getBounds());
                this.store.listenerManager.fireFeaturesChanged(this.live.getFeatureType().getTypeName(), Transaction.AUTO_COMMIT, bounds, false);
            } else {
                this.store.listenerManager.fireFeaturesAdded(this.live.getFeatureType().getTypeName(), Transaction.AUTO_COMMIT, this.live.getBounds(), false);
            }
        }
        this.origional = null;
        this.live = null;
    }

    public void remove() throws IOException {
        if (this.live == null) {
            throw new IOException("No current feature to remove");
        }
        if (this.origional != null) {
            this.store.listenerManager.fireFeaturesRemoved(this.live.getFeatureType().getTypeName(), Transaction.AUTO_COMMIT, this.origional.getBounds(), false);
        }
        this.origional = null;
        this.live = null;
    }

    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("writer already closed");
        }
        while (this.reader.hasNext()) {
            this.reader.next();
            this.writer.next();
            this.writer.echoLine(this.reader.line);
        }
        this.writer.close();
        this.reader.close();
        this.writer = null;
        this.reader = null;
        this.read.delete();
        this.write.renameTo(this.read);
        this.read = null;
        this.write = null;
        this.store = null;
    }
}

