/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.mappane;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.gui.swing.JMapPane;
import org.geotools.gui.swing.PanAction;
import org.geotools.gui.swing.ResetAction;
import org.geotools.gui.swing.SelectAction;
import org.geotools.gui.swing.ZoomInAction;
import org.geotools.gui.swing.ZoomOutAction;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapViewer {
    JFrame frame = new JFrame("My Map Viewer");
    JMapPane mp;
    JToolBar jtb;
    JLabel text;

    public MapViewer() {
        this.frame.setBounds(20, 20, 450, 200);
        this.frame.setDefaultCloseOperation(3);
        Container content = this.frame.getContentPane();
        this.mp = new JMapPane();
        content.setLayout(new BorderLayout());
        this.jtb = new JToolBar();
        ZoomInAction zoomIn = new ZoomInAction(this.mp);
        ZoomOutAction zoomOut = new ZoomOutAction(this.mp);
        PanAction pan = new PanAction(this.mp);
        SelectAction select = new SelectAction(this.mp);
        ResetAction reset = new ResetAction(this.mp);
        this.jtb.add((Action)zoomIn);
        this.jtb.add((Action)zoomOut);
        this.jtb.add((Action)pan);
        this.jtb.addSeparator();
        this.jtb.add((Action)reset);
        this.jtb.addSeparator();
        this.jtb.add((Action)select);
        final JButton button = new JButton();
        button.setText("CRS");
        button.setToolTipText("Change map prjection");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String code = JOptionPane.showInputDialog(button, "Coordinate Reference System:", "EPSG:4326");
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)code);
                    MapViewer.this.setCRS(crs);
                }
                catch (FactoryException fe) {
                    JOptionPane.showMessageDialog(button, fe.getMessage(), ((Object)((Object)fe)).getClass().toString(), 0);
                    return;
                }
            }
        });
        this.jtb.add(button);
        content.add((Component)this.jtb, "North");
        this.mp.setSize(400, 200);
        content.add((Component)this.mp, "Center");
        content.doLayout();
        this.frame.setVisible(true);
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.mp.getContext().setAreaOfInterest((Envelope)this.mp.getContext().getAreaOfInterest(), crs);
        this.mp.setReset(true);
        this.mp.repaint();
    }

    public void load(URL shape, URL sld) throws Exception {
        ShapefileDataStore ds = new ShapefileDataStore(shape);
        FeatureSource fs = ds.getFeatureSource();
        Envelope env = fs.getBounds();
        this.mp.setMapArea(env);
        StyleFactory factory = StyleFactoryFinder.createStyleFactory();
        SLDParser stylereader = new SLDParser(factory, sld);
        Style[] style = stylereader.readXML();
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        context.addLayer(fs, style[0]);
        context.getLayerBounds();
        this.mp.setHighlightLayer(context.getLayer(0));
        StreamingRenderer renderer = new StreamingRenderer();
        this.mp.setRenderer((GTRenderer)renderer);
        this.mp.setContext((MapContext)context);
        this.frame.repaint();
        this.frame.doLayout();
    }

    public static URL aquireURL(String target) {
        if (new File(target).exists()) {
            try {
                return new File(target).toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        try {
            return new URL(target);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String filepart;
        URL sld;
        String pathname;
        URL shape;
        if (args.length == 0 || !args[0].toLowerCase().endsWith(".shp")) {
            System.out.println("java org.geotools.gui.swing.MapViewer shapefile.shp");
            System.out.println("Notes:");
            System.out.println(" Any provided shapefile.prj file or shapefile.sld will be used");
            System.exit(0);
        }
        if ((shape = MapViewer.aquireURL(pathname = args[0])) == null) {
            System.err.println("Could not find shapefile: " + pathname);
            System.exit(1);
        }
        if ((sld = MapViewer.aquireURL((filepart = pathname.substring(0, pathname.lastIndexOf("."))) + ".sld")) == null) {
            System.err.println("Could not find sld file: " + filepart + ".sld");
            System.exit(1);
        }
        MapViewer mapV = new MapViewer();
        mapV.load(shape, sld);
    }
}

