/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.bindings.GML;
import org.geotools.xml.ComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.geotools.xml.Schemas;
import org.geotools.xs.bindings.XS;
import org.picocontainer.MutablePicoContainer;

public class GMLAbstractFeatureTypeBinding
implements ComplexBinding {
    private static Map typeMap = new HashMap();
    FeatureTypeCache ftCache;

    public GMLAbstractFeatureTypeBinding(FeatureTypeCache ftCache) {
        this.ftCache = ftCache;
    }

    public QName getTarget() {
        return GML.ABSTRACTFEATURETYPE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return FeatureType.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        XSDElementDeclaration decl = instance.getElementDeclaration();
        FeatureType fType = this.ftCache.get(decl.getName());
        if (fType == null) {
            DefaultFeatureTypeFactory ftBuilder = new DefaultFeatureTypeFactory();
            ftBuilder.setName(decl.getName());
            ftBuilder.setName(decl.getTargetNamespace());
            List children = Schemas.getChildElementDeclarations((XSDElementDeclaration)decl);
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                XSDElementDeclaration property = (XSDElementDeclaration)itr.next();
                if ("boundedBy".equals(property.getName())) continue;
                XSDTypeDefinition type = property.getType();
                QName qName = new QName(type.getTargetNamespace(), type.getName());
                Class theClass = (Class)typeMap.get(qName);
                if (theClass == null) {
                    throw new RuntimeException("Could not find class for " + qName);
                }
                ftBuilder.addType(AttributeTypeFactory.newAttributeType((String)property.getName(), (Class)theClass));
            }
            fType = ftBuilder.getFeatureType();
            this.ftCache.put(fType);
        }
        Feature f = fType.create(new Object[fType.getAttributeCount()]);
        Iterator itr = node.getChildren().iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            f.setAttribute(child.getComponent().getName(), child.getValue());
        }
        return f;
    }

    static {
        typeMap.put(XS.STRING, String.class);
        typeMap.put(XS.INT, Integer.class);
        typeMap.put(XS.INTEGER, Integer.class);
        typeMap.put(XS.DECIMAL, Double.class);
        typeMap.put(XS.DOUBLE, Double.class);
        typeMap.put(XS.FLOAT, Float.class);
        typeMap.put(XS.SHORT, Short.class);
        typeMap.put(XS.DATE, Calendar.class);
        typeMap.put(XS.DATETIME, Calendar.class);
        typeMap.put(XS.TIME, Calendar.class);
        typeMap.put(XS.BOOLEAN, Boolean.class);
        typeMap.put(XS.LONG, Long.class);
        typeMap.put(GML.POINTMEMBERTYPE, Point.class);
        typeMap.put(GML.POINTPROPERTYTYPE, Point.class);
        typeMap.put(GML.POINTTYPE, Point.class);
        typeMap.put(GML.LINESTRINGMEMBERTYPE, LineString.class);
        typeMap.put(GML.LINESTRINGPROPERTYTYPE, LineString.class);
        typeMap.put(GML.LINESTRINGTYPE, LineString.class);
        typeMap.put(GML.LINEARRINGMEMBERTYPE, LinearRing.class);
        typeMap.put(GML.LINEARRINGTYPE, LinearRing.class);
        typeMap.put(GML.POLYGONMEMBERTYPE, Polygon.class);
        typeMap.put(GML.POLYGONPROPERTYTYPE, Polygon.class);
        typeMap.put(GML.POLYGONTYPE, Polygon.class);
        typeMap.put(GML.MULTIGEOMETRYPROPERTYTYPE, GeometryCollection.class);
        typeMap.put(GML.MULTIPOINTPROPERTYTYPE, MultiPoint.class);
        typeMap.put(GML.MULTIPOINTTYPE, MultiPoint.class);
        typeMap.put(GML.MULTILINESTRINGPROPERTYTYPE, MultiLineString.class);
        typeMap.put(GML.MULTIPOLYGONPROPERTYTYPE, MultiPolygon.class);
        typeMap.put(GML.MULTIPOLYGONTYPE, MultiPolygon.class);
        typeMap.put(GML.FEATUREASSOCIATIONTYPE, Feature.class);
    }
}

