/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml2.bindings.GML;
import org.geotools.gml2.bindings.GMLUtil;
import org.geotools.xml.ComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GMLLineStringTypeBinding
implements ComplexBinding {
    CoordinateSequenceFactory csFactory;
    GeometryFactory gFactory;

    public GMLLineStringTypeBinding(CoordinateSequenceFactory csFactory, GeometryFactory gFactory) {
        this.csFactory = csFactory;
        this.gFactory = gFactory;
    }

    public QName getTarget() {
        return GML.LINESTRINGTYPE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return null;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List coordinates = node.getChildren("coord");
        if (coordinates.size() == 1) {
            throw new RuntimeException("Linestring must have at least 2 coordinates");
        }
        if (!coordinates.isEmpty()) {
            Node cnode = (Node)coordinates.get(0);
            CoordinateSequence seq = (CoordinateSequence)cnode.getValue();
            int dimension = GMLUtil.getDimension(seq);
            CoordinateSequence lineSeq = this.csFactory.create(coordinates.size(), dimension);
            for (int i = 0; i < coordinates.size(); ++i) {
                cnode = (Node)coordinates.get(i);
                seq = (CoordinateSequence)cnode.getValue();
                for (int j = 0; j < dimension; ++j) {
                    lineSeq.setOrdinate(i, j, seq.getOrdinate(0, j));
                }
            }
            return this.gFactory.createLineString(lineSeq);
        }
        if (node.getChild("coordinates") != null) {
            Node cnode = node.getChild("coordinates");
            CoordinateSequence lineSeq = (CoordinateSequence)cnode.getValue();
            return this.gFactory.createLineString(lineSeq);
        }
        throw new RuntimeException("Could not find coordinates to build linestring");
    }

    public void encode(Object object, Element element, Document document) {
    }

    public Object getChild(Object object, QName name) {
        return null;
    }
}

